package com.qianhe.service.impl;

import java.util.List;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.qianhe.mapper.SjGfjsLbzdbfJgMapper;
import com.qianhe.domain.SjGfjsLbzdbfJg;
import com.qianhe.service.ISjGfjsLbzdbfJgService;

/**
 * 规范建设-练兵指导帮扶结果Service业务层处理
 *
 * @author qianhe
 * @date 2025-08-19
 */
@Service
public class SjGfjsLbzdbfJgServiceImpl implements ISjGfjsLbzdbfJgService
{
    @Autowired
    private SjGfjsLbzdbfJgMapper sjGfjsLbzdbfJgMapper;

    /**
     * 查询规范建设-练兵指导帮扶结果
     *
     * @param id 规范建设-练兵指导帮扶结果主键
     * @return 规范建设-练兵指导帮扶结果
     */
    @Override
    public SjGfjsLbzdbfJg selectSjGfjsLbzdbfJgById(Long id)
    {
        return sjGfjsLbzdbfJgMapper.selectSjGfjsLbzdbfJgById(id);
    }

    /**
     * 查询规范建设-练兵指导帮扶结果列表
     *
     * @param sjGfjsLbzdbfJg 规范建设-练兵指导帮扶结果
     * @return 规范建设-练兵指导帮扶结果
     */
    @Override
    public List<SjGfjsLbzdbfJg> selectSjGfjsLbzdbfJgList(SjGfjsLbzdbfJg sjGfjsLbzdbfJg)
    {
        return sjGfjsLbzdbfJgMapper.selectSjGfjsLbzdbfJgList(sjGfjsLbzdbfJg);
    }

    /**
     * 新增规范建设-练兵指导帮扶结果
     *
     * @param sjGfjsLbzdbfJg 规范建设-练兵指导帮扶结果
     * @return 结果
     */
    @Override
    public int insertSjGfjsLbzdbfJg(SjGfjsLbzdbfJg sjGfjsLbzdbfJg)
    {
        sjGfjsLbzdbfJg.setCreateTime(DateUtils.getNowDate());
        sjGfjsLbzdbfJg.setCreateBy(SecurityUtils.getUsername());
        return sjGfjsLbzdbfJgMapper.insertSjGfjsLbzdbfJg(sjGfjsLbzdbfJg);
    }

    /**
     * 修改规范建设-练兵指导帮扶结果
     *
     * @param sjGfjsLbzdbfJg 规范建设-练兵指导帮扶结果
     * @return 结果
     */
    @Override
    public int updateSjGfjsLbzdbfJg(SjGfjsLbzdbfJg sjGfjsLbzdbfJg)
    {
        sjGfjsLbzdbfJg.setUpdateTime(DateUtils.getNowDate());
        sjGfjsLbzdbfJg.setUpdateBy(SecurityUtils.getUsername());
        return sjGfjsLbzdbfJgMapper.updateSjGfjsLbzdbfJg(sjGfjsLbzdbfJg);
    }

    /**
     * 批量删除规范建设-练兵指导帮扶结果
     *
     * @param ids 需要删除的规范建设-练兵指导帮扶结果主键
     * @return 结果
     */
    @Override
    public int deleteSjGfjsLbzdbfJgByIds(Long[] ids)
    {
        return sjGfjsLbzdbfJgMapper.deleteSjGfjsLbzdbfJgByIds(ids);
    }

    /**
     * 删除规范建设-练兵指导帮扶结果信息
     *
     * @param id 规范建设-练兵指导帮扶结果主键
     * @return 结果
     */
    @Override
    public int deleteSjGfjsLbzdbfJgById(Long id)
    {
        return sjGfjsLbzdbfJgMapper.deleteSjGfjsLbzdbfJgById(id);
    }
}
