package com.qianhe.service.impl;

import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.domain.SjGfjsKhwt;
import com.qianhe.domain.SjGfjsKhwtCb;
import com.qianhe.mapper.SjGfjsKhwtMapper;
import com.qianhe.service.ISjGfjsKhwtService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * 规范建设-考核问题 原否决项标准Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-22
 */
@Service
public class SjGfjsKhwtServiceImpl implements ISjGfjsKhwtService
{
    @Autowired
    private SjGfjsKhwtMapper sjGfjsKhwtMapper;

    /**
     * 查询规范建设-考核问题 原否决项标准
     *
     * @param id 规范建设-考核问题 原否决项标准主键
     * @return 规范建设-考核问题 原否决项标准
     */
    @Override
    public SjGfjsKhwt selectSjGfjsKhwtById(Long id)
    {
        SjGfjsKhwt sjGfjsKhwt = sjGfjsKhwtMapper.selectSjGfjsKhwtById(id);
        List<SjGfjsKhwtCb> cbList=sjGfjsKhwtMapper.selectSjGfjsKhwtCbById(id);
        sjGfjsKhwt.setSjGfjsKhwtCbList(cbList);
        return sjGfjsKhwt;
    }

    /**
     * 查询规范建设-考核问题 原否决项标准列表
     *
     * @param sjGfjsKhwt 规范建设-考核问题 原否决项标准
     * @return 规范建设-考核问题 原否决项标准
     */
    @Override
    public List<SjGfjsKhwt> selectSjGfjsKhwtList(SjGfjsKhwt sjGfjsKhwt)
    {
        return sjGfjsKhwtMapper.selectSjGfjsKhwtList(sjGfjsKhwt);
    }

    /**
     * 新增规范建设-考核问题 原否决项标准
     *
     * @param sjGfjsKhwt 规范建设-考核问题 原否决项标准
     * @return 结果
     */
    @Transactional
    @Override
    public int insertSjGfjsKhwt(SjGfjsKhwt sjGfjsKhwt)
    {
        sjGfjsKhwt.setCreateTime(DateUtils.getNowDate());
        int rows = sjGfjsKhwtMapper.insertSjGfjsKhwt(sjGfjsKhwt);
        insertSjGfjsKhwtCb(sjGfjsKhwt);
        return rows;
    }

    /**
     * 修改规范建设-考核问题 原否决项标准
     *
     * @param sjGfjsKhwt 规范建设-考核问题 原否决项标准
     * @return 结果
     */
    @Transactional
    @Override
    public int updateSjGfjsKhwt(SjGfjsKhwt sjGfjsKhwt)
    {
        sjGfjsKhwt.setUpdateTime(DateUtils.getNowDate());
        sjGfjsKhwtMapper.deleteSjGfjsKhwtCbByZbId(sjGfjsKhwt.getId());
        insertSjGfjsKhwtCb(sjGfjsKhwt);
        return sjGfjsKhwtMapper.updateSjGfjsKhwt(sjGfjsKhwt);
    }

    /**
     * 批量删除规范建设-考核问题 原否决项标准
     *
     * @param ids 需要删除的规范建设-考核问题 原否决项标准主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSjGfjsKhwtByIds(Long[] ids)
    {
        sjGfjsKhwtMapper.deleteSjGfjsKhwtCbByZbIds(ids);
        return sjGfjsKhwtMapper.deleteSjGfjsKhwtByIds(ids);
    }

    /**
     * 删除规范建设-考核问题 原否决项标准信息
     *
     * @param id 规范建设-考核问题 原否决项标准主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSjGfjsKhwtById(Long id)
    {
        sjGfjsKhwtMapper.deleteSjGfjsKhwtCbByZbId(id);
        return sjGfjsKhwtMapper.deleteSjGfjsKhwtById(id);
    }

    @Override
    public List<SjGfjsKhwt> selectSjGfjsKhwtCxList(SjGfjsKhwt sjGfjsKhwt) {
        return sjGfjsKhwtMapper.selectSjGfjsKhwtCxList(sjGfjsKhwt);
    }

    @Override
    public List<String> getFlmcList(SjGfjsKhwtCb cb) {
        return sjGfjsKhwtMapper.getFlmcList(cb);
    }

    @Override
    public List<SjGfjsKhwtCb> getPjbzList(SjGfjsKhwtCb cb) {
        return sjGfjsKhwtMapper.getPjbzList(cb);
    }

    /**
     * 新增规范建设-考核问题 原否决项标准从信息
     *
     * @param sjGfjsKhwt 规范建设-考核问题 原否决项标准对象
     */
    public void insertSjGfjsKhwtCb(SjGfjsKhwt sjGfjsKhwt)
    {
        List<SjGfjsKhwtCb> sjGfjsKhwtCbList = sjGfjsKhwt.getSjGfjsKhwtCbList();
        Long id = sjGfjsKhwt.getId();
        if (StringUtils.isNotNull(sjGfjsKhwtCbList))
        {
            List<SjGfjsKhwtCb> list = new ArrayList<SjGfjsKhwtCb>();
            for (int i=0;i<sjGfjsKhwtCbList.size();i++)
            {
                SjGfjsKhwtCb sjGfjsKhwtCb = sjGfjsKhwtCbList.get(i);
                sjGfjsKhwtCb.setFlmc(sjGfjsKhwt.getFlmc());
                sjGfjsKhwtCb.setNd(sjGfjsKhwt.getNd());
                sjGfjsKhwtCb.setPx(i+1L);
                sjGfjsKhwtCb.setZbId(id);
                list.add(sjGfjsKhwtCb);
            }
            if (list.size() > 0)
            {
                sjGfjsKhwtMapper.batchSjGfjsKhwtCb(list);
            }
        }
    }
}
