package com.qianhe.service.impl;

import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.domain.SjGfjsZsdwwtcj;
import com.qianhe.mapper.SjGfjsJgbmjcMapper;
import com.qianhe.service.ISjGfjsJgbmjcService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 规范建设-机关部门检查Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-23
 */
@Service
public class SjGfjsJgbmjcServiceImpl implements ISjGfjsJgbmjcService
{
    @Autowired
    private SjGfjsJgbmjcMapper sjGfjsJcdwwtcjMapper;

    /**
     * 查询规范建设-机关部门检查
     *
     * @param id 规范建设-机关部门检查主键
     * @return 规范建设-机关部门检查
     */
    @Override
    public SjGfjsZsdwwtcj selectSjGfjsZsdwwtcjById(Long id)
    {
        SjGfjsZsdwwtcj zsdwwtcj = sjGfjsJcdwwtcjMapper.selectSjGfjsZsdwwtcjById(id);
        return zsdwwtcj;
    }

    /**
     * 查询规范建设-机关部门检查列表
     *
     * @param sjGfjsZsdwwtcj 规范建设-机关部门检查
     * @return 规范建设-机关部门检查
     */
    @Override
    @DataScope(deptAlias = "c")
    public List<SjGfjsZsdwwtcj> selectSjGfjsZsdwwtcjList(SjGfjsZsdwwtcj sjGfjsZsdwwtcj)
    {
        return sjGfjsJcdwwtcjMapper.selectSjGfjsZsdwwtcjList(sjGfjsZsdwwtcj);
    }

    /**
     * 新增规范建设-机关部门检查
     *
     * @param sjGfjsZsdwwtcj 规范建设-机关部门检查
     * @return 结果
     */
    @Override
    public int insertSjGfjsZsdwwtcj(SjGfjsZsdwwtcj sjGfjsZsdwwtcj)
    {
        sjGfjsZsdwwtcj.setCreateTime(DateUtils.getNowDate());
        sjGfjsZsdwwtcj.setCreateBy(SecurityUtils.getUsername());
        return sjGfjsJcdwwtcjMapper.insertSjGfjsZsdwwtcj(sjGfjsZsdwwtcj);
    }

    /**
     * 修改规范建设-机关部门检查
     *
     * @param sjGfjsZsdwwtcj 规范建设-机关部门检查
     * @return 结果
     */
    @Override
    public int updateSjGfjsZsdwwtcj(SjGfjsZsdwwtcj sjGfjsZsdwwtcj)
    {
        sjGfjsZsdwwtcj.setUpdateTime(DateUtils.getNowDate());
        sjGfjsZsdwwtcj.setUpdateBy(SecurityUtils.getUsername());
        return sjGfjsJcdwwtcjMapper.updateSjGfjsZsdwwtcj(sjGfjsZsdwwtcj);
    }

    /**
     * 批量删除规范建设-机关部门检查
     *
     * @param ids 需要删除的规范建设-机关部门检查主键
     * @return 结果
     */
    @Override
    public int deleteSjGfjsZsdwwtcjByIds(Long[] ids)
    {
        return sjGfjsJcdwwtcjMapper.deleteSjGfjsZsdwwtcjByIds(ids);
    }

    /**
     * 删除规范建设-机关部门检查信息
     *
     * @param id 规范建设-机关部门检查主键
     * @return 结果
     */
    @Override
    public int deleteSjGfjsZsdwwtcjById(Long id)
    {
        return sjGfjsJcdwwtcjMapper.deleteSjGfjsZsdwwtcjById(id);
    }

    @Override
    public int batchSave(List<SjGfjsZsdwwtcj> list) {
        return sjGfjsJcdwwtcjMapper.batchSave(list);
    }
}
