package com.qianhe.service;

import com.qianhe.domain.JygxCljwh;

import java.util.List;


/**
 * 经验共享-超链接维护Service接口
 *
 * @author qianhe
 * @date 2024-07-30
 */
public interface IJygxCljwhService
{
    /**
     * 查询经验共享-超链接维护
     *
     * @param cljid 经验共享-超链接维护主键
     * @return 经验共享-超链接维护
     */
    public JygxCljwh selectJygxCljwhByCljid(Long cljid);

    /**
     * 查询经验共享-超链接维护列表
     *
     * @param jygxCljwh 经验共享-超链接维护
     * @return 经验共享-超链接维护集合
     */
    public List<JygxCljwh> selectJygxCljwhList(JygxCljwh jygxCljwh);

    /**
     * 新增经验共享-超链接维护
     *
     * @param jygxCljwh 经验共享-超链接维护
     * @return 结果
     */
    public int insertJygxCljwh(JygxCljwh jygxCljwh);

    /**
     * 修改经验共享-超链接维护
     *
     * @param jygxCljwh 经验共享-超链接维护
     * @return 结果
     */
    public int updateJygxCljwh(JygxCljwh jygxCljwh);

    /**
     * 批量删除经验共享-超链接维护
     *
     * @param cljids 需要删除的经验共享-超链接维护主键集合
     * @return 结果
     */
    public int deleteJygxCljwhByCljids(Long[] cljids);

    /**
     * 删除经验共享-超链接维护信息
     *
     * @param cljid 经验共享-超链接维护主键
     * @return 结果
     */
    public int deleteJygxCljwhByCljid(Long cljid);
}
