package com.qianhe.domain;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;

/**
 * 文档-文档维护对象 wd_wdwh
 *
 * @author qianhe
 * @date 2024-02-28
 */
@Data
public class WdWdwh extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 年度 */
    @Excel(name = "年度")
    private String year;

    /** 类型 */
    @Excel(name = "类型")
    private String typeId;

    /** 类型 */
    @Excel(name = "类型")
    private String typeName;

    /** 单位id */
    @Excel(name = "单位id")
    private String deptId;

    /** 单位名称 */
    @Excel(name = "单位名称")
    private String deptName;
    /** 二级单位 */
    @Excel(name = "二级单位")
    private String ejdeptId;

    /** 二级单位名称 */
    @Excel(name = "二级单位名称")
    private String ejdeptName;

    /** 文件关联id */
    @Excel(name = "文件关联id")
    private String fjId;

    /** 录入人 */
    @Excel(name = "录入人")
    private String lrr;

    /** 录入时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "录入时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date lrsj;

    /** 修改人 */
    @Excel(name = "修改人")
    private String xgr;

    /** 修改时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "修改时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date xgsj;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 预留1 */
    @Excel(name = "预留1")
    private String yl1;

    /** 预留2 */
    @Excel(name = "预留2")
    private String yl2;

    /** 预留3 */
    @Excel(name = "预留3")
    private String yl3;

    /** 预留4 */
    @Excel(name = "预留4")
    private String yl4;

    /** 预留5 */
    @Excel(name = "预留5")
    private String yl5;

    //附件名称
    private String fjmc;
    //附件地址
    private String fjdz;
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date scsj;
    /** 上传人 */
    private String scr;
    private String num;

    private List<WdWdxx> fileList;

}
