package com.qianhe.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.qianhe.domain.Vo.JcdwxxVo;

import com.qianhe.common.core.domain.entity.SysDept;
import com.qianhe.system.domain.SysDeptCb;
import com.qianhe.system.service.ISysDeptCbService;
import com.qianhe.system.service.ISysDeptService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.domain.SjBzxx;
import com.qianhe.service.ISjBzxxService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

import static org.apache.commons.lang3.StringUtils.isNumeric;

/**
 * 班组信息Controller
 *
 * @author qianhe
 * @date 2025-08-04
 */
@RestController
@RequestMapping("/system/sjBzxx")
public class SjBzxxController extends BaseController
{
    @Autowired
    private ISjBzxxService sjBzxxService;
    @Autowired
    private ISysDeptService deptService;
    @Autowired
    private ISysDeptCbService sysDeptCbService;

    /**
     * 查询班组信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SjBzxx sjBzxx)
    {
        startPage();
        List<SjBzxx> list = sjBzxxService.selectSjBzxxList(sjBzxx);
        return getDataTable(list);
    }

    /**
     * 导出班组信息列表
     */
    @Log(title = "班组信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjBzxx sjBzxx)
    {
        List<SjBzxx> list = sjBzxxService.selectSjBzxxList(sjBzxx);
        ExcelUtil<SjBzxx> util = new ExcelUtil<SjBzxx>(SjBzxx.class);
        util.exportExcel(response, list, "班组信息数据");
    }

    /**
     * 获取班组信息详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjBzxxService.selectSjBzxxById(id));
    }

    /**
     * 新增班组信息
     */
    @Log(title = "班组信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjBzxx sjBzxx)
    {
        return toAjax(sjBzxxService.insertSjBzxx(sjBzxx));
    }

    /**
     * 修改班组信息
     */
    @Log(title = "班组信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjBzxx sjBzxx)
    {
        return toAjax(sjBzxxService.updateSjBzxx(sjBzxx));
    }

    /**
     * 删除班组信息
     */
    @Log(title = "班组信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjBzxxService.deleteSjBzxxByIds(ids));
    }





    /**
     * 获取班组 统计信息
     */
    @PostMapping(value = "/getBzTj")
    public AjaxResult getBzTj(@RequestBody SjBzxx sjBzxx)
    {
        return success(sjBzxxService.selectBzxxTj(sjBzxx));
    }
    /**
     * 批量提交
     */
    @PostMapping(value = "/pltj")
    public AjaxResult pltj(@RequestBody SjBzxx sjBzxx)
    {
        sjBzxx.setZt("1");
        return success(sjBzxxService.pltj(sjBzxx));
    }



    /** 查询统计 单位班组人数统计信息 */
    @GetMapping("/dwbzrstjList")
    public List<SjBzxx> dwbzrstjList(SjBzxx sjBzxx)
    {
        List<SjBzxx> list = sjBzxxService.dwbzrstjList(sjBzxx);
        return list;
    }


    /**
     * 基层单位信息统计
     * @return
     */
    @GetMapping("/jcdwtjList")
    public TableDataInfo jcdwtjList(JcdwxxVo jcdwxxVo)
    {
        startPage();
        List<JcdwxxVo> list = sjBzxxService.jcdwtjList(jcdwxxVo);

        return getDataTable( list);
    }

    /**
     * 导出班组信息列表
     */
    @Log(title = "班组信息", businessType = BusinessType.EXPORT)
    @PostMapping("/exporJcdw")
    public void exporJcdw(HttpServletResponse response, JcdwxxVo jcdwxxVo)
    {
        List<JcdwxxVo> list = sjBzxxService.jcdwtjList(jcdwxxVo);
        ExcelUtil<JcdwxxVo> util = new ExcelUtil<JcdwxxVo>(JcdwxxVo.class);
        util.exportExcel(response, list, "班组信息数据");
    }




    //组织机构加班组 组合查询
    @GetMapping("/deptAndBzList")
    public AjaxResult deptAndBzList(SysDept dept)
    {
        List<SysDept> depts = deptService.selectDeptList(dept);
        //查询从表 配置信息
        SysDeptCb cb_qry = new SysDeptCb();
        cb_qry.setNd("2025");
        List<SysDeptCb> cb_list = sysDeptCbService.selectSysDeptCbList(cb_qry);
        //查询班组
        SjBzxx bz_qry = new SjBzxx();
        List<SjBzxx> bz_list = sjBzxxService.selectSjBzxxList(bz_qry);

        for (SysDept dp : depts) {
            Long deptId = dp.getDeptId();
            String deptIdString = deptId.toString(); // 将Long类型转换为String类型
            SysDeptCb dpcb = cb_list.stream().filter(e-> deptIdString.equals(e.getDeptId())).findAny().orElse(new SysDeptCb());
            Long jcrysl = dpcb.getJcrysl();//设置的 从表的 基层人员数量
            String dwlx = dpcb.getDwlx();//设置的 从表的 单位类型

            //从班组中求和的人员数量
            double sum = bz_list.stream().filter(bzxx -> bzxx.getDeptId() != null && deptId.equals(bzxx.getDeptId()))
                    .map(SjBzxx::getRs).map(rs -> rs == null ? "" : rs.trim()).filter(StringUtils::isNumeric)
                    .mapToDouble(Double::parseDouble).sum();

            dp.setDeptLx(dwlx);
            if (sum > 0) {
                dp.setYgrs(String.valueOf(sum));
            } else {
                dp.setYgrs(String.valueOf(jcrysl));
            }
        }

        for (SjBzxx bz : bz_list){
            SysDept dptmp = new SysDept();
            dptmp.setDeptId(bz.getDeptId() + 100000L);//班组id 前面加 10万 保证不重复
            dptmp.setDeptName(bz.getBzmc());
            dptmp.setParentId(bz.getDeptId());
            dptmp.setDwjb("5");//一般是班组
            dptmp.setDelFlag("0");
            dptmp.setStatus(bz.getZt());
            dptmp.setDeptLx(bz.getBzlx());//一般是班组
            dptmp.setYgrs(bz.getRs());//一般是班组
            dptmp.setBzid(bz.getId());
            dptmp.setIsbz("班组");//是否班组
            depts.add(dptmp);
        }

        return success(depts);
    }
}
