package com.qianhe.domain;

import java.util.List;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;

/**
 * 指导帮扶-考核评价标准对象 sj_zdbf_khpjbz
 *
 * @author qianhe
 * @date 2024-07-22
 */
@Data
public class SjZdbfKhpjbz extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 年度 */
    @Excel(name = "年度")
    private String nd;

    /** 类型(采油管理区、专业化基础单位、科研基层单位、服务协调基础单位) */
    @Excel(name = "类型(采油管理区、专业化基础单位、科研基层单位、服务协调基础单位)")
    private String lx;

    /** 考核内容 */
    @Excel(name = "考核内容")
    private String khnr;

    /** 考核项点 */
    @Excel(name = "考核项点")
    private String khxd;

    /** 考核内容分数 */
    @Excel(name = "考核内容分数")
    private String khnrfs;

    /** 考核项点排序 */
    @Excel(name = "考核项点排序")
    private Long xppx;

    /** 预留1 */
    @Excel(name = "预留1")
    private String yl1;

    /** 预留2 */
    @Excel(name = "预留2")
    private String yl2;

    /** 预留3 */
    @Excel(name = "预留3")
    private String yl3;

    /** 预留4 */
    @Excel(name = "预留4")
    private String yl4;

    /** 预留5 */
    @Excel(name = "预留5")
    private String yl5;


    /** 指导帮扶-考核评价标准从信息 */
    private List<SjZdbfKhpjbzCb> sjZdbfKhpjbzCbList;


    private String pjbz;

    /** 排序 */
    private Long px;


    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setNd(String nd)
    {
        this.nd = nd;
    }

    public String getNd()
    {
        return nd;
    }
    public void setLx(String lx)
    {
        this.lx = lx;
    }

    public String getLx()
    {
        return lx;
    }
    public void setKhnr(String khnr)
    {
        this.khnr = khnr;
    }

    public String getKhnr()
    {
        return khnr;
    }
    public void setKhxd(String khxd)
    {
        this.khxd = khxd;
    }

    public String getKhxd()
    {
        return khxd;
    }
    public void setKhnrfs(String khnrfs)
    {
        this.khnrfs = khnrfs;
    }

    public String getKhnrfs()
    {
        return khnrfs;
    }
    public void setXppx(Long xppx)
    {
        this.xppx = xppx;
    }

    public Long getXppx()
    {
        return xppx;
    }
    public void setYl1(String yl1)
    {
        this.yl1 = yl1;
    }

    public String getYl1()
    {
        return yl1;
    }
    public void setYl2(String yl2)
    {
        this.yl2 = yl2;
    }

    public String getYl2()
    {
        return yl2;
    }
    public void setYl3(String yl3)
    {
        this.yl3 = yl3;
    }

    public String getYl3()
    {
        return yl3;
    }
    public void setYl4(String yl4)
    {
        this.yl4 = yl4;
    }

    public String getYl4()
    {
        return yl4;
    }
    public void setYl5(String yl5)
    {
        this.yl5 = yl5;
    }

    public String getYl5()
    {
        return yl5;
    }

    public List<SjZdbfKhpjbzCb> getSjZdbfKhpjbzCbList()
    {
        return sjZdbfKhpjbzCbList;
    }

    public void setSjZdbfKhpjbzCbList(List<SjZdbfKhpjbzCb> sjZdbfKhpjbzCbList)
    {
        this.sjZdbfKhpjbzCbList = sjZdbfKhpjbzCbList;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("nd", getNd())
            .append("lx", getLx())
            .append("khnr", getKhnr())
            .append("khxd", getKhxd())
            .append("khnrfs", getKhnrfs())
            .append("xppx", getXppx())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .append("yl1", getYl1())
            .append("yl2", getYl2())
            .append("yl3", getYl3())
            .append("yl4", getYl4())
            .append("yl5", getYl5())
            .append("sjZdbfKhpjbzCbList", getSjZdbfKhpjbzCbList())
            .toString();
    }
}
