package com.qianhe.domain;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 三基-例会上传对象 sj_lhsc
 *
 * @author qianhe
 * @date 2024-07-08
 */
@Data
public class SjLhsc extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 会议名称 */
    @Excel(name = "会议名称")
    private String hymc;

    /** 会议日期 */
    @Excel(name = "会议日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date hyrq;

    /** 单位 */
    @Excel(name = "单位")
    private String deptId;

    private String parentId;

    /** 会议地点 */
    @Excel(name = "会议地点")
    private String hydd;

    /** 参会人员 */
    @Excel(name = "参会人员")
    private String chry;

    /** 运行情况 */
    @Excel(name = "运行情况")
    private String yxqk;

    /** 解决问题 */
    @Excel(name = "解决问题")
    private String jjwt;

    /** 存在问题 */
    @Excel(name = "存在问题")
    private String czwt;

    /** 推广经验 */
    @Excel(name = "推广经验")
    private String tgjy;

    /** 领导要求 */
    @Excel(name = "领导要求")
    private String ldyq;

    /** 状态（已提交、未提交） */
    @Excel(name = "状态", readConverterExp = "已=提交、未提交")
    private String zt;

    /** 单位级别（ 3、4级） */
    @Excel(name = "单位级别", readConverterExp = "3=、4级")
    private String dwjb;

    /** 提交人 */
    @Excel(name = "提交人")
    private String tjr;

    /** 提交日期 */
    @Excel(name = "提交日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd  HH:mm:ss")
    private Date tjrq;

    /** 预留1 */
    @Excel(name = "预留1")
    private String yl1;

    /** 预留2 */
    @Excel(name = "预留2")
    private String yl2;

    /** 预留3 */
    @Excel(name = "预留3")
    private String yl3;

    /** 预留4 */
    @Excel(name = "预留4")
    private String yl4;

    /** 预留5 */
    @Excel(name = "预留5")
    private String yl5;

    /** 三基-例会上传-存在问题信息 */
    private List<SjLhscWt> sjLhscWtList;

    private List<String> wtList;

    private String nd;
    private List<WdWdxx> fileList;

    private String deptName;


    private String startJd;
    private String endJd;
    /**
     * 季度
     */
    private String jd;

}
