package com.qianhe.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.domain.GgFjb;
import com.qianhe.service.IGgFjbService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 公共附件Controller
 *
 * @author qianhe
 * @date 2025-08-04
 */
@RestController
@RequestMapping("/system/ggFjb")
public class GgFjbController extends BaseController
{
    @Autowired
    private IGgFjbService ggFjbService;

    /**
     * 查询公共附件列表
     */
    @GetMapping("/list")
    public TableDataInfo list(GgFjb ggFjb)
    {
        startPage();
        List<GgFjb> list = ggFjbService.selectGgFjbList(ggFjb);
        return getDataTable(list);
    }

    /**
     * 导出公共附件列表
     */
    @Log(title = "公共附件", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, GgFjb ggFjb)
    {
        List<GgFjb> list = ggFjbService.selectGgFjbList(ggFjb);
        ExcelUtil<GgFjb> util = new ExcelUtil<GgFjb>(GgFjb.class);
        util.exportExcel(response, list, "公共附件数据");
    }

    /**
     * 获取公共附件详细信息
     */
    @GetMapping(value = "/{ID}")
    public AjaxResult getInfo(@PathVariable("ID") Long ID)
    {
        return success(ggFjbService.selectGgFjbByID(ID));
    }

    /**
     * 新增公共附件
     */
    @Log(title = "公共附件", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody GgFjb ggFjb)
    {
        return toAjax(ggFjbService.insertGgFjb(ggFjb));
    }

    /**
     * 修改公共附件
     */
    @Log(title = "公共附件", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody GgFjb ggFjb)
    {
        return toAjax(ggFjbService.updateGgFjb(ggFjb));
    }

    /**
     * 删除公共附件
     */
    @Log(title = "公共附件", businessType = BusinessType.DELETE)
	@DeleteMapping("/{IDs}")
    public AjaxResult remove(@PathVariable Long[] IDs)
    {
        return toAjax(ggFjbService.deleteGgFjbByIDs(IDs));
    }
}
