package com.qianhe.system.service;

import java.util.List;
import com.qianhe.system.domain.SysDeptFl;

/**
 * 单位分类Service接口
 * 
 * @author qianhe
 * @date 2024-07-22
 */
public interface ISysDeptFlService 
{
    /**
     * 查询单位分类
     * 
     * @param id 单位分类主键
     * @return 单位分类
     */
    public SysDeptFl selectSysDeptFlById(Long id);

    /**
     * 查询单位分类列表
     * 
     * @param sysDeptFl 单位分类
     * @return 单位分类集合
     */
    public List<SysDeptFl> selectSysDeptFlList(SysDeptFl sysDeptFl);

    /**
     * 新增单位分类
     * 
     * @param sysDeptFl 单位分类
     * @return 结果
     */
    public int insertSysDeptFl(SysDeptFl sysDeptFl);

    /**
     * 修改单位分类
     * 
     * @param sysDeptFl 单位分类
     * @return 结果
     */
    public int updateSysDeptFl(SysDeptFl sysDeptFl);

    /**
     * 批量删除单位分类
     * 
     * @param ids 需要删除的单位分类主键集合
     * @return 结果
     */
    public int deleteSysDeptFlByIds(Long[] ids);

    /**
     * 删除单位分类信息
     * 
     * @param id 单位分类主键
     * @return 结果
     */
    public int deleteSysDeptFlById(Long id);
}
