package com.qianhe.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.core.domain.entity.SysDept;
import com.qianhe.common.core.domain.entity.SysDictData;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.domain.SjZdbfZsdwkhpjZb;
import com.qianhe.mapper.SjZdbfZsdwkhpjZbMapper;
import com.qianhe.system.mapper.SysDeptMapper;
import com.qianhe.system.mapper.SysDictDataMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.qianhe.mapper.SjZdbfZsdwkhpjMapper;
import com.qianhe.domain.SjZdbfZsdwkhpj;
import com.qianhe.service.ISjZdbfZsdwkhpjService;

/**
 * 指导帮扶-直属单位考核评价Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-24
 */
@Service
public class SjZdbfZsdwkhpjServiceImpl implements ISjZdbfZsdwkhpjService
{
    @Autowired
    private SjZdbfZsdwkhpjMapper sjZdbfZsdwkhpjMapper;
    @Autowired
    private SjZdbfZsdwkhpjZbMapper sjZdbfZsdwkhpjZbMapper;
    @Autowired
    private SysDictDataMapper sysDictDataMapper;
    @Autowired
    private SysDeptMapper sysDeptMapper;

    /**
     * 查询指导帮扶-直属单位考核评价
     *
     * @param id 指导帮扶-直属单位考核评价主键
     * @return 指导帮扶-直属单位考核评价
     */
    @Override
    public SjZdbfZsdwkhpj selectSjZdbfZsdwkhpjById(Long id)
    {
        return sjZdbfZsdwkhpjMapper.selectSjZdbfZsdwkhpjById(id);
    }

    /**
     * 查询指导帮扶-直属单位考核评价列表
     *
     * @param sjZdbfZsdwkhpj 指导帮扶-直属单位考核评价
     * @return 指导帮扶-直属单位考核评价
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<SjZdbfZsdwkhpj> selectSjZdbfZsdwkhpjList(SjZdbfZsdwkhpj sjZdbfZsdwkhpj)
    {
        return sjZdbfZsdwkhpjMapper.selectSjZdbfZsdwkhpjList(sjZdbfZsdwkhpj);
    }

    /**
     * 新增指导帮扶-直属单位考核评价
     *
     * @param sjZdbfZsdwkhpj 指导帮扶-直属单位考核评价
     * @return 结果
     */
    @Override
    public int insertSjZdbfZsdwkhpj(SjZdbfZsdwkhpj sjZdbfZsdwkhpj)
    {
        sjZdbfZsdwkhpj.setCreateTime(DateUtils.getNowDate());
        return sjZdbfZsdwkhpjMapper.insertSjZdbfZsdwkhpj(sjZdbfZsdwkhpj);
    }

    /**
     * 修改指导帮扶-直属单位考核评价
     *
     * @param sjZdbfZsdwkhpj 指导帮扶-直属单位考核评价
     * @return 结果
     */
    @Override
    public int updateSjZdbfZsdwkhpj(SjZdbfZsdwkhpj sjZdbfZsdwkhpj)
    {
        sjZdbfZsdwkhpj.setUpdateTime(DateUtils.getNowDate());
        sjZdbfZsdwkhpj.setUpdateBy(SecurityUtils.getUsername());
        //计算分数
        return sjZdbfZsdwkhpjMapper.updateSjZdbfZsdwkhpj(sjZdbfZsdwkhpj);
    }

    /**
     * 批量删除指导帮扶-直属单位考核评价
     *
     * @param ids 需要删除的指导帮扶-直属单位考核评价主键
     * @return 结果
     */
    @Override
    public int deleteSjZdbfZsdwkhpjByIds(Long[] ids)
    {
        return sjZdbfZsdwkhpjMapper.deleteSjZdbfZsdwkhpjByIds(ids);
    }

    /**
     * 删除指导帮扶-直属单位考核评价信息
     *
     * @param id 指导帮扶-直属单位考核评价主键
     * @return 结果
     */
    @Override
    public int deleteSjZdbfZsdwkhpjById(Long id)
    {
        return sjZdbfZsdwkhpjMapper.deleteSjZdbfZsdwkhpjById(id);
    }

    @Override
    public int batchSave(List<SjZdbfZsdwkhpj> addList) {
        return sjZdbfZsdwkhpjMapper.batchSave(addList);
    }

    @Override
    public int pledit(List<SjZdbfZsdwkhpj> list) {
        //计算分数
        SjZdbfZsdwkhpj sjZdbfZsdwkhpj = list.get(0);
        SjZdbfZsdwkhpjZb sjZdbfZsdwkhpjZb = sjZdbfZsdwkhpjZbMapper.selectSjZdbfZsdwkhpjZbById(sjZdbfZsdwkhpj.getZbId());
        SysDept dept = sysDeptMapper.selectDeptById(sjZdbfZsdwkhpjZb.getDeptId());
        Map<String,List<SjZdbfZsdwkhpj>> stringListMap = list.stream().collect(Collectors.groupingBy(SjZdbfZsdwkhpj::getKhnr));
        List<SysDictData> zdbfKhnr = sysDictDataMapper.selectDictDataByType("zdbf_khnr");
        for(SysDictData data:zdbfKhnr){
            String dictValue = data.getDictValue();
            List<SjZdbfZsdwkhpj> sjZdbfZsdwkhpjs = stringListMap.get(data.getDictValue());
            //计算分数
            List<Double> doubleList=new ArrayList<>();
            if(sjZdbfZsdwkhpjs==null){
                continue;
            }
            sjZdbfZsdwkhpjs.forEach(item->{
                if(StringUtils.isEmpty(item.getKhfz())){
                    item.setKhfz("0");
                }
                doubleList.add(Double.parseDouble(item.getKhfz()));
            });
            double kf = doubleList.stream().mapToDouble(Double::doubleValue).sum();
            if("党建引领".equals(dictValue)){
                //扣分
                sjZdbfZsdwkhpjZb.setDjyjkfs(new BigDecimal(kf));
                //扣分比列
                BigDecimal df = sjZdbfZsdwkhpjZb.getDjyjzfs().add(new BigDecimal(kf));
                BigDecimal kfbl =df.divide(sjZdbfZsdwkhpjZb.getDjyjzfs(),BigDecimal.ROUND_CEILING).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP);
                sjZdbfZsdwkhpjZb.setDjyjkfbl(new BigDecimal(100).subtract(kfbl));
                //得分
                sjZdbfZsdwkhpjZb.setDjyjdf(df);


            } else if ("素质提升".equals(dictValue)) {
//扣分
                sjZdbfZsdwkhpjZb.setSztskfs(new BigDecimal(kf));
                //扣分比列
                BigDecimal df = sjZdbfZsdwkhpjZb.getSztszfs().add(new BigDecimal(kf));
                BigDecimal kfbl =df.divide(sjZdbfZsdwkhpjZb.getSztszfs(),BigDecimal.ROUND_CEILING).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP);
                sjZdbfZsdwkhpjZb.setSztsfbl(new BigDecimal(100).subtract(kfbl));
                //得分
                sjZdbfZsdwkhpjZb.setSztsdf(df);
            } else if ("管理精益".equals(dictValue)) {
                sjZdbfZsdwkhpjZb.setGlgfkfs(new BigDecimal(kf));
                //扣分比列
                BigDecimal df = sjZdbfZsdwkhpjZb.getGlgfzfs().add(new BigDecimal(kf));
                BigDecimal kfbl =df.divide(sjZdbfZsdwkhpjZb.getGlgfzfs(),BigDecimal.ROUND_CEILING).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP);
                sjZdbfZsdwkhpjZb.setGlgfbl(new BigDecimal(100).subtract(kfbl));
                //得分
                sjZdbfZsdwkhpjZb.setGlgfdf(df);
            } else if ("业务创效".equals(dictValue)) {
                sjZdbfZsdwkhpjZb.setYwcxkfs(new BigDecimal(kf));
                //扣分比列
                BigDecimal df = sjZdbfZsdwkhpjZb.getYwcxzfs().add(new BigDecimal(kf));
                BigDecimal kfbl =df.divide(sjZdbfZsdwkhpjZb.getYwcxzfs(),BigDecimal.ROUND_CEILING).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP);
                sjZdbfZsdwkhpjZb.setYwcxbl(new BigDecimal(100).subtract(kfbl));
                //得分
                sjZdbfZsdwkhpjZb.setYwcxdf(df);
            }

        }

        BigDecimal sum = sjZdbfZsdwkhpjZb.getDjyjzfs().add(sjZdbfZsdwkhpjZb.getSztszfs()).add(sjZdbfZsdwkhpjZb.getGlgfzfs()).add(sjZdbfZsdwkhpjZb.getYwcxzfs());
        //总得分
        BigDecimal sunfs = sjZdbfZsdwkhpjZb.getDjyjdf().add(sjZdbfZsdwkhpjZb.getSztsdf()).add(sjZdbfZsdwkhpjZb.getGlgfdf()).add(sjZdbfZsdwkhpjZb.getYwcxdf());
        sjZdbfZsdwkhpjZb.setZdf(sunfs);
        //总扣分
        sjZdbfZsdwkhpjZb.setZkf(sum.subtract(sunfs));
        //总扣分比例
        BigDecimal bigDecimal = sunfs.divide(sum,BigDecimal.ROUND_CEILING).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP);
        sjZdbfZsdwkhpjZb.setZkfbl(new BigDecimal(100).subtract(bigDecimal));
        //综合得分
        String deptDfl = dept.getDeptDfl();
        if(StringUtils.isNotEmpty(deptDfl)){
           if ("B类".equals(deptDfl)) {
              sjZdbfZsdwkhpjZb.setZhdf( sunfs.multiply(new BigDecimal(0.9)).setScale(2, BigDecimal.ROUND_HALF_UP));
            }else if ("C类".equals(deptDfl)) {
               sjZdbfZsdwkhpjZb.setZhdf( sunfs.multiply(new BigDecimal(0.85)).setScale(2, BigDecimal.ROUND_HALF_UP));
            }else {
               sjZdbfZsdwkhpjZb.setZhdf(sunfs);
           }
        }
        //更新主表
        sjZdbfZsdwkhpjZbMapper.updateSjZdbfZsdwkhpjZb(sjZdbfZsdwkhpjZb);
        return sjZdbfZsdwkhpjMapper.pledit(list);
    }

    public static void main(String[] args) {
        System.out.println(Double.parseDouble("-5"));
        System.out.println(Double.parseDouble("+5"));
    }


}
