package com.qianhe.service.impl;

import java.util.List;

import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.qianhe.mapper.SjZdbfZsdwfjxcjMapper;
import com.qianhe.domain.SjZdbfZsdwfjxcj;
import com.qianhe.service.ISjZdbfZsdwfjxcjService;

/**
 * 指导帮扶-直属单位否决项采集Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-24
 */
@Service
public class SjZdbfZsdwfjxcjServiceImpl implements ISjZdbfZsdwfjxcjService
{
    @Autowired
    private SjZdbfZsdwfjxcjMapper sjZdbfZsdwfjxcjMapper;

    /**
     * 查询指导帮扶-直属单位否决项采集
     *
     * @param id 指导帮扶-直属单位否决项采集主键
     * @return 指导帮扶-直属单位否决项采集
     */
    @Override
    public SjZdbfZsdwfjxcj selectSjZdbfZsdwfjxcjById(Long id)
    {
        return sjZdbfZsdwfjxcjMapper.selectSjZdbfZsdwfjxcjById(id);
    }

    /**
     * 查询指导帮扶-直属单位否决项采集列表
     *
     * @param sjZdbfZsdwfjxcj 指导帮扶-直属单位否决项采集
     * @return 指导帮扶-直属单位否决项采集
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<SjZdbfZsdwfjxcj> selectSjZdbfZsdwfjxcjList(SjZdbfZsdwfjxcj sjZdbfZsdwfjxcj)
    {
        return sjZdbfZsdwfjxcjMapper.selectSjZdbfZsdwfjxcjList(sjZdbfZsdwfjxcj);
    }

    /**
     * 新增指导帮扶-直属单位否决项采集
     *
     * @param sjZdbfZsdwfjxcj 指导帮扶-直属单位否决项采集
     * @return 结果
     */
    @Override
    public int insertSjZdbfZsdwfjxcj(SjZdbfZsdwfjxcj sjZdbfZsdwfjxcj)
    {
        sjZdbfZsdwfjxcj.setCreateTime(DateUtils.getNowDate());
        sjZdbfZsdwfjxcj.setCreateBy(SecurityUtils.getUsername());
        return sjZdbfZsdwfjxcjMapper.insertSjZdbfZsdwfjxcj(sjZdbfZsdwfjxcj);
    }

    /**
     * 修改指导帮扶-直属单位否决项采集
     *
     * @param sjZdbfZsdwfjxcj 指导帮扶-直属单位否决项采集
     * @return 结果
     */
    @Override
    public int updateSjZdbfZsdwfjxcj(SjZdbfZsdwfjxcj sjZdbfZsdwfjxcj)
    {
        sjZdbfZsdwfjxcj.setUpdateTime(DateUtils.getNowDate());
        sjZdbfZsdwfjxcj.setUpdateBy(SecurityUtils.getUsername());
        return sjZdbfZsdwfjxcjMapper.updateSjZdbfZsdwfjxcj(sjZdbfZsdwfjxcj);
    }

    /**
     * 批量删除指导帮扶-直属单位否决项采集
     *
     * @param ids 需要删除的指导帮扶-直属单位否决项采集主键
     * @return 结果
     */
    @Override
    public int deleteSjZdbfZsdwfjxcjByIds(Long[] ids)
    {
        return sjZdbfZsdwfjxcjMapper.deleteSjZdbfZsdwfjxcjByIds(ids);
    }

    /**
     * 删除指导帮扶-直属单位否决项采集信息
     *
     * @param id 指导帮扶-直属单位否决项采集主键
     * @return 结果
     */
    @Override
    public int deleteSjZdbfZsdwfjxcjById(Long id)
    {
        return sjZdbfZsdwfjxcjMapper.deleteSjZdbfZsdwfjxcjById(id);
    }

    @Override
    public int batchSave(List<SjZdbfZsdwfjxcj> list) {
        return sjZdbfZsdwfjxcjMapper.batchSave(list);
    }
}
