package com.qianhe.service.impl;

import java.math.BigDecimal;
import java.util.List;

import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.domain.entity.SysDept;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.domain.Vo.SjfybpVo;
import com.qianhe.domain.WdLxwh;
import com.qianhe.domain.WdWdxx;
import com.qianhe.mapper.SjFybpWhMapper;
import com.qianhe.mapper.WdWdxxMapper;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import java.util.stream.Collectors;

import com.qianhe.common.utils.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import com.qianhe.domain.SjFybpWh;
import com.qianhe.mapper.SjFybpMapper;
import com.qianhe.domain.SjFybp;
import com.qianhe.service.ISjFybpService;

/**
 * 三基-费用报批Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-05
 */
@Service
public class SjFybpServiceImpl implements ISjFybpService
{
    @Autowired
    private SjFybpMapper sjFybpMapper;

    @Autowired
    private SjFybpWhMapper sjFybpWhMapper;
    @Autowired
    private WdWdxxMapper wdWdxxMapper;

    /**
     * 查询三基-费用报批
     *
     * @param id 三基-费用报批主键
     * @return 三基-费用报批
     */
    @Override
    public SjFybp selectSjFybpById(Long id)
    {
        SjFybp sjFybp = sjFybpMapper.selectSjFybpById(id);
        //查询费用维护
        SjFybpWh sjFybpWh=new SjFybpWh();
        sjFybpWh.setFybpId(id);
        List<SjFybpWh> sjFybpWhs = sjFybpWhMapper.selectSjFybpWhList(sjFybpWh);
        sjFybp.setSjFybpWhList(sjFybpWhs);
        //查询文档
        WdWdxx wdWdxx=new WdWdxx();
        wdWdxx.setGlId(sjFybp.getId().toString());
        wdWdxx.setMkmc("费用报批");
        wdWdxx.setFjlx("费用上报");
        List<WdWdxx> wdWdxxes = wdWdxxMapper.selectWdWdxxList(wdWdxx);
        sjFybp.setFileList(wdWdxxes);
        return sjFybp;
    }

    /**
     * 查询三基-费用报批列表
     *
     * @param sjFybp 三基-费用报批
     * @return 三基-费用报批
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<SjFybp> selectSjFybpList(SjFybp sjFybp)
    {
        return sjFybpMapper.selectSjFybpList(sjFybp);
    }

    /**
     * 新增三基-费用报批
     *
     * @param sjFybp 三基-费用报批
     * @return 结果
     */
    @Transactional
    @Override
    public int insertSjFybp(SjFybp sjFybp)
    {
        sjFybp.setCreateTime(DateUtils.getNowDate());
        sjFybp.setCreateBy(SecurityUtils.getUsername());
        int rows = sjFybpMapper.insertSjFybp(sjFybp);
        //保存文件
        if(StringUtils.isNotEmpty(sjFybp.getFileList())){
            if(sjFybp.getFileList().size()>0){
                sjFybp.getFileList().forEach(file->{
                    file.setGlId(sjFybp.getId().toString());
                    file.setMkmc("费用报批");
                    file.setFjlx("费用上报");
                    file.setLrr(SecurityUtils.getUsername());
                    wdWdxxMapper.insertWdWdxx(file);
                });
            }
        }


        return rows;
    }

    /**
     * 修改三基-费用报批
     *
     * @param sjFybp 三基-费用报批
     * @return 结果
     */
    @Transactional
    @Override
    public int updateSjFybp(SjFybp sjFybp)
    {
        //先删除文件
        wdWdxxMapper.deleteWdWdxxByGlIdAndMkmc(sjFybp.getId()+"","费用报批");
        //保存文件
        if(StringUtils.isNotEmpty(sjFybp.getFileList())){
            if(sjFybp.getFileList().size()>0){
                sjFybp.getFileList().forEach(file->{
                    file.setGlId(sjFybp.getId().toString());
                    file.setMkmc("费用报批");
                    file.setFjlx("费用上报");
                    file.setLrr(SecurityUtils.getUsername());
                    wdWdxxMapper.insertWdWdxx(file);
                });
            }
        }
        sjFybp.setUpdateTime(DateUtils.getNowDate());
        sjFybp.setUpdateBy(SecurityUtils.getUsername());
        return sjFybpMapper.updateSjFybp(sjFybp);
    }

    /**
     * 批量删除三基-费用报批
     *
     * @param ids 需要删除的三基-费用报批主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSjFybpByIds(Long[] ids)
    {
        sjFybpMapper.deleteSjFybpWhByFybpIds(ids);
        return sjFybpMapper.deleteSjFybpByIds(ids);
    }

    /**
     * 删除三基-费用报批信息
     *
     * @param id 三基-费用报批主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSjFybpById(Long id)
    {
        sjFybpMapper.deleteSjFybpWhByFybpId(id);
        return sjFybpMapper.deleteSjFybpById(id);
    }

    @Override
    public int tj(SjFybp sjFybp) {
       if("待审批".equals(sjFybp.getZt())){
           sjFybp.setTjr(SecurityUtils.getUsername());
           sjFybp.setTjrq(DateUtils.dateTimeNow("yyyy-MM-dd HH:mm:ss"));
       }else if("已批复".equals(sjFybp.getZt()) || "已驳回" .equals(sjFybp.getZt())) {
           sjFybp.setSpr(SecurityUtils.getUsername());
           sjFybp.setSprq(DateUtils.dateTimeNow("yyyy-MM-dd HH:mm:ss"));
       }
        return sjFybpMapper.updateSjFybp(sjFybp);
    }

    @Override
    public int fywh(SjFybp sjFybp) {
        sjFybpMapper.deleteSjFybpWhByFybpId(sjFybp.getId());
        if(StringUtils.isNotEmpty(sjFybp.getSjFybpWhList())){
            //统计已结算金额
            BigDecimal reduce = sjFybp.getSjFybpWhList().stream().map(SjFybpWh::getSyje).reduce(BigDecimal.ZERO, BigDecimal::add);
            sjFybp.setYsyje(reduce);
            sjFybpMapper.updateSjFybp(sjFybp);
        }
        insertSjFybpWh(sjFybp);
        return 1;
    }

    @Override
    @DataScope(deptAlias = "d")
    public List<SjfybpVo> tjtbByDept(SjFybp sjFybp) {
        return sjFybpMapper.tjtbByDept(sjFybp);
    }

    @Override
    @DataScope(deptAlias = "d")
    public  List<SjfybpVo> tjtbByfylx(SjFybp sjFybp) {
        List<SjfybpVo> voList = sjFybpMapper.tjtbByfylx(sjFybp);
        //计算总数
        SjfybpVo vo =new SjfybpVo();
        vo.setFylxmc("总");
        vo.setFylx("总");
        int sum = voList.stream().mapToInt(SjfybpVo::getZsl).sum();
        vo.setZsl(sum);
        BigDecimal xmje = voList.stream().map(SjfybpVo::getXmje).reduce(BigDecimal.ZERO, BigDecimal::add);
        vo.setXmje(xmje);
        BigDecimal yjyje = voList.stream().map(SjfybpVo::getYsyje).reduce(BigDecimal.ZERO, BigDecimal::add);
        vo.setYsyje(yjyje);
        voList.add(0, vo);
        return voList;
    }

    @Override
//    @DataScope(deptAlias = "d")
    public List<SjFybp> getFygz(SjFybp sjFybp) {
        return sjFybpMapper.getFygz(sjFybp);
    }

    @Override
    public SjFybp getFygzById(Long id) {
        SjFybp sjFybp = sjFybpMapper.getFygzById(id);
        //查询费用维护
        SjFybpWh sjFybpWh=new SjFybpWh();
        sjFybpWh.setFybpId(id);
        List<SjFybpWh> sjFybpWhs = sjFybpWhMapper.selectSjFybpWhList(sjFybpWh);
        sjFybp.setSjFybpWhList(sjFybpWhs);
        return sjFybp;
    }

    @Override
    @DataScope(deptAlias = "d")
    public List<SjFybp> selectSjFybpCtList(SjFybp sjFybp) {
        return sjFybpMapper.selectSjFybpCtList(sjFybp);
    }

    /**
     * 新增三基-费用维护信息
     *
     * @param sjFybp 三基-费用报批对象
     */
    public void insertSjFybpWh(SjFybp sjFybp)
    {
        List<SjFybpWh> sjFybpWhList = sjFybp.getSjFybpWhList();
        Long id = sjFybp.getId();
        if (StringUtils.isNotNull(sjFybpWhList))
        {
            List<SjFybpWh> list = new ArrayList<SjFybpWh>();
            for (SjFybpWh sjFybpWh : sjFybpWhList)
            {
                sjFybpWh.setFybpId(id);
                list.add(sjFybpWh);
            }
            if (list.size() > 0)
            {
                sjFybpMapper.batchSjFybpWh(list);
            }
        }
    }
}
