package com.qianhe.service.impl;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;

import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.core.domain.entity.SysRole;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.domain.*;
import com.qianhe.mapper.JygxLxwhMapper;
import com.qianhe.mapper.JygxWzglMapper;
import com.qianhe.service.IJygxWzglService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 经验共享-文章管理Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-29
 */
@Service
public class JygxWzglServiceImpl implements IJygxWzglService
{
    @Autowired
    private JygxWzglMapper jygxWzglMapper;

    @Autowired
    private JygxLxwhMapper jygxLxwhMapper;
    /**
     * 查询经验共享-文章管理
     *
     * @param wzid 经验共享-文章管理主键
     * @return 经验共享-文章管理
     */
    @Override
    public JygxWzgl selectJygxWzglByWzid(Long wzid)
    {
        JygxWzgl jygxWzgl = jygxWzglMapper.selectJygxWzglByWzid(wzid);
        //查询文章管理附件集合
        List<JygxWzglfj> jygxWzglfjs = jygxWzglMapper.selectFile(wzid);
        if(jygxWzglfjs.size()>0){
            jygxWzgl.setJygxWzglfjList(jygxWzglfjs);
        }
        return jygxWzgl;
    }

    /**
     * 查询经验共享-文章管理
     *
     * @param wzid 经验共享-文章管理主键
     * @return 经验共享-文章管理
     */
    @Override
    public JygxWzgl selectsyWzid(Long wzid)
    {
        JygxWzgl jygxWzgl = jygxWzglMapper.selectJygxWzglByWzid(wzid);
        //查询文章管理附件集合
        List<JygxWzglfj> jygxWzglfjs = jygxWzglMapper.selectFile(wzid);

        jygxWzglMapper.update(jygxWzgl);
        if(jygxWzglfjs.size()>0){
            jygxWzgl.setJygxWzglfjList(jygxWzglfjs);
        }
        return jygxWzgl;
    }

    /**
     * 查询经验共享-文章管理列表
     *
     * @param jygxWzgl 经验共享-文章管理
     * @return 经验共享-文章管理
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<JygxWzgl> selectJygxWzglList(JygxWzgl jygxWzgl)
    {
        return jygxWzglMapper.selectJygxWzglList(jygxWzgl);
    }

    /**
     * 查询经验共享-文章管理列表
     *
     * @param jygxWzgl 经验共享-文章管理
     * @return 经验共享-文章管理
     */
    @Override
    public List<JygxWzgl> selectList(JygxWzgl jygxWzgl)
    {
        return jygxWzglMapper.selectList(jygxWzgl);
    }

    /**
     * 查询经验共享-首页轮播图新闻
     *
     * @param jygxWzgl
     * @return
     */
    @Override
    public List<JygxWzgl> selectSylbxwList(JygxWzgl jygxWzgl)
    {
        return jygxWzglMapper.selectSylbxwList(jygxWzgl);
    }

    /**
     * 新增经验共享-文章管理
     *
     * @param jygxWzgl 经验共享-文章管理
     * @return 结果
     */
    @Override
    public int insertJygxWzgl(JygxWzgl jygxWzgl)
    {


        int TARGET_LENGTH = 20;
        SecureRandom random = new SecureRandom();
        BigInteger bigInt = new BigInteger(TARGET_LENGTH * 8, random);
        long longValue = bigInt.longValue();

        jygxWzgl.setWzid(longValue);
        if (jygxWzgl.getJygxWzglfjList() != null ) {
            if (jygxWzgl.getJygxWzglfjList().size()>0) {
                List<JygxWzglfj> sbmsList = jygxWzgl.getJygxWzglfjList();
                insertFileList(jygxWzgl.getWzid(), sbmsList);
            }
        }
        jygxWzgl.setCreateBy(SecurityUtils.getUsername());
        jygxWzgl.setCreateTime(DateUtils.getNowDate());
        jygxWzgl.setDeptId(SecurityUtils.getDeptId());
        return jygxWzglMapper.insertJygxWzgl(jygxWzgl);
    }


    /**
     * 新增首页轮播新闻
     */
    @Override
    public int insertxw(JygxWzgl jygxWzgl)
    {

        int TARGET_LENGTH = 20;
        SecureRandom random = new SecureRandom();
        BigInteger bigInt = new BigInteger(TARGET_LENGTH * 8, random);
        long longValue = bigInt.longValue();

        jygxWzgl.setWzid(longValue);
        if (jygxWzgl.getJygxWzglfjList() != null ) {
            if (jygxWzgl.getJygxWzglfjList().size()>0) {
                List<JygxWzglfj> sbmsList = jygxWzgl.getJygxWzglfjList();
                insertFileList(jygxWzgl.getWzid(), sbmsList);
            }
        }

        if( jygxWzgl.getWznr()!= null){
            jygxWzgl.setYl2(jygxWzgl.getWznr().replaceAll("<[^>]*>", ""));
        }

        jygxWzgl.setLxmc("syxw");
        jygxWzgl.setCreateBy(SecurityUtils.getUsername());
        jygxWzgl.setCreateTime(DateUtils.getNowDate());
        return jygxWzglMapper.insertJygxWzgl(jygxWzgl);
    }

    /**
     * 批量新增附件
     * @param id
     * @param list
     */
    public void insertFileList(Long id, List<JygxWzglfj> list){
        list.forEach(list1 -> {
            list1.setWzid(id);
            list1.setCreateBy(SecurityUtils.getUsername());
            list1.setCreateTime(DateUtils.getNowDate());
        });
        jygxWzglMapper.insertFile(list);
    }

    /**
     * 修改经验共享-文章管理
     *
     * @param jygxWzgl 经验共享-文章管理
     * @return 结果
     */
    @Override
    public int updateJygxWzgl(JygxWzgl jygxWzgl)
    {
            if (jygxWzgl.getJygxWzglfjList() != null ) {
                if (jygxWzgl.getJygxWzglfjList().size()>0) {
                    //将之前上传附件删除,重新上传
                    jygxWzglMapper.deleteFileByBusinessId(jygxWzgl.getWzid());
                    List<JygxWzglfj> sbmsList = jygxWzgl.getJygxWzglfjList();
                    insertFileList(jygxWzgl.getWzid(), sbmsList);
                }
            }
       if( jygxWzgl.getWznr()!= null){
           jygxWzgl.setYl2(jygxWzgl.getWznr().replaceAll("<[^>]*>", ""));
       }


        jygxWzgl.setUpdateTime(DateUtils.getNowDate());
        return jygxWzglMapper.updateJygxWzgl(jygxWzgl);
    }


    /**
     * 提交

     */
    @Override
    public int updatetj(JygxWzgl jygxWzgl)
    {
        boolean pd = false;
        if(SecurityUtils.getLoginUser().getUser().isAdmin()){
            pd = true;
        }
        List<SysRole> roles = SecurityUtils.getLoginUser().getUser().getRoles();
        if(!pd){
            for(SysRole sysRole :roles){
                if(sysRole.getRoleKey().equals("sjgly")){
                    pd = true;
                    break;
                }
            }
        }
        if(pd){
            jygxWzgl.setShzt("4");
        }
        if (jygxWzgl.getJygxWzglfjList() != null ) {
            if (jygxWzgl.getJygxWzglfjList().size()>0) {
                //将之前上传附件删除,重新上传
                jygxWzglMapper.deleteFileByBusinessId(jygxWzgl.getWzid());
                List<JygxWzglfj> sbmsList = jygxWzgl.getJygxWzglfjList();
                insertFileList(jygxWzgl.getWzid(), sbmsList);
            }
        }
        if( jygxWzgl.getWznr()!= null){
            jygxWzgl.setYl2(jygxWzgl.getWznr().replaceAll("<[^>]*>", ""));
        }


        jygxWzgl.setUpdateTime(DateUtils.getNowDate());
        return jygxWzglMapper.updateJygxWzgl(jygxWzgl);
    }
    /**
     * 批量删除经验共享-文章管理
     *
     * @param wzids 需要删除的经验共享-文章管理主键
     * @return 结果
     */
    @Override
    public int deleteJygxWzglByWzids(Long[] wzids)
    {
        return jygxWzglMapper.deleteJygxWzglByWzids(wzids);
    }

    /**
     * 删除经验共享-文章管理信息
     *
     * @param wzid 经验共享-文章管理主键
     * @return 结果
     */
    @Override
    public int deleteJygxWzglByWzid(Long wzid)
    {
        //附件删除
        jygxWzglMapper.deleteFileByBusinessId(wzid);
        return jygxWzglMapper.deleteJygxWzglByWzid(wzid);
    }


    /**
     *数据置顶
     */
    @Override
    public int updatewzzd(JygxWzgl jygxWzgl)
    {
        jygxWzglMapper.updatezd(jygxWzgl);
        jygxWzgl.setPx((long) 0);
        return jygxWzglMapper.updateJygxWzgl(jygxWzgl);
    }


    /**
     *取消置顶
     */
    @Override
    public int updateqxzd(JygxWzgl jygxWzgl)
    {
        return jygxWzglMapper.updateqxzd(jygxWzgl);
    }


    /**
     * 首页搜索类型条数
     *
     */
    @Override
    public List<Ssfl> selectcxflList(JygxWzgl jygxWzgl)
    {
        return jygxWzglMapper.selectcxflList(jygxWzgl);
    }

    /**
     * 首页搜索
     *
     */
    @Override
    public List<JygxWzgl> selectsyssList(JygxWzgl jygxWzgl)
    {
        return jygxWzglMapper.selectsyssList(jygxWzgl);
    }

    /**
     * 首页经验交流
     */
    @Override
    public List<Jyjl> selectjyjlList()
    {
        JygxLxwh jygxLxwh = new JygxLxwh();
        jygxLxwh.setMkmc("经验交流");

        List<Jyjl> jyjlsList = new ArrayList<>();
        List<JygxLxwh> jygxLxwhs = jygxLxwhMapper.selectJygxLxwhList(jygxLxwh);
        for (int i = 0; i < jygxLxwhs.size(); i++) {

            JygxWzgl jygxWzgl1 = new JygxWzgl();
            jygxWzgl1.setLxmc(jygxLxwhs.get(i).getLxmc());
            jygxWzgl1.setShzt("4");
            List<JygxWzgl> jygxWzgls = jygxWzglMapper.selectJygxWzglList(jygxWzgl1);

            if(jygxWzgls.size()>0){
                Jyjl jyjls1 =  new Jyjl();
                jyjls1.setLxmc(jygxLxwhs.get(i).getLxmc());
                jyjls1.setJygxWzglList(jygxWzgls);
                jyjlsList.add(jyjls1);
            }

        }

        return jyjlsList;
    }

}
