package com.qianhe.domain;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;

/**
 * 指导帮扶-直属单位问题采集对象 sj_zdbf_zsdwwtcj
 *
 * @author qianhe
 * @date 2024-07-23
 */
@Data
public class SjZdbfZsdwwtcj extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 单位id */
    @Excel(name = "单位id")
    private Long deptId;

    /** 日期 */
    @Excel(name = "日期")
    private String rq;

    /** 检查级别（直属单位自查、三级帮扶组、机关部门专项检查） */
    @Excel(name = "检查级别", readConverterExp = "直=属单位自查、三级帮扶组、机关部门专项检查")
    private String jcjb;

    /** 问题描述 */
    @Excel(name = "问题描述")
    private String wtmc;

    /** 考核内容 */
    @Excel(name = "考核内容")
    private String khnr;

    /** 考核项点 */
    @Excel(name = "考核项点")
    private String khxd;

    /** 评价标准id */
    @Excel(name = "评价标准id")
    private String pjbzid;

    /** 评价标准名称 */
    @Excel(name = "评价标准名称")
    private String pjbzmc;

    /** 整改责任人 */
    @Excel(name = "整改责任人")
    private String zgzrr;

    /** 整改措施 */
    @Excel(name = "整改措施")
    private String zgcs;

    /** 整改期限 */
    @Excel(name = "整改期限")
    private String zgqx;

    /** 整改状态 */
    @Excel(name = "整改状态")
    private String zgzt;

    /** 预留1 */
    @Excel(name = "预留1")
    private String yl1;

    /** 预留2 */
    @Excel(name = "预留2")
    private String yl2;

    /** 预留3 */
    @Excel(name = "预留3")
    private String yl3;

    /** 预留4 */
    @Excel(name = "预留4")
    private String yl4;

    /** 预留5 */
    @Excel(name = "预留5")
    private String yl5;

    private String deptName;

    private String startRq;
    private String endRq;

    private String deptLx;
}
