package com.qianhe.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.qianhe.domain.JygxYyxtwh;
import com.qianhe.service.IJygxYyxtwhService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;

import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 经验共享-应用系统维护Controller
 *
 * @author qianhe
 * @date 2024-07-29
 */
@RestController
@RequestMapping("/system/yyxtwh")
public class JygxYyxtwhController extends BaseController
{
    @Autowired
    private IJygxYyxtwhService jygxYyxtwhService;

    /**
     * 查询经验共享-应用系统维护列表
     */
    @PreAuthorize("@ss.hasPermi('system:yyxtwh:list')")
    @GetMapping("/list")
    public TableDataInfo list(JygxYyxtwh jygxYyxtwh)
    {
        startPage();
        List<JygxYyxtwh> list = jygxYyxtwhService.selectJygxYyxtwhList(jygxYyxtwh);
        return getDataTable(list);
    }

    /**
     * 导出经验共享-应用系统维护列表
     */
    @PreAuthorize("@ss.hasPermi('system:yyxtwh:export')")
    @Log(title = "经验共享-应用系统维护", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, JygxYyxtwh jygxYyxtwh)
    {
        List<JygxYyxtwh> list = jygxYyxtwhService.selectJygxYyxtwhList(jygxYyxtwh);
        ExcelUtil<JygxYyxtwh> util = new ExcelUtil<JygxYyxtwh>(JygxYyxtwh.class);
        util.exportExcel(response, list, "经验共享-应用系统维护数据");
    }

    /**
     * 获取经验共享-应用系统维护详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:yyxtwh:query')")
    @GetMapping(value = "/{yyxtid}")
    public AjaxResult getInfo(@PathVariable("yyxtid") Long yyxtid)
    {
        return success(jygxYyxtwhService.selectJygxYyxtwhByYyxtid(yyxtid));
    }

    /**
     * 新增经验共享-应用系统维护
     */
    @PreAuthorize("@ss.hasPermi('system:yyxtwh:add')")
    @Log(title = "经验共享-应用系统维护", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody JygxYyxtwh jygxYyxtwh)
    {
        return toAjax(jygxYyxtwhService.insertJygxYyxtwh(jygxYyxtwh));
    }

    /**
     * 修改经验共享-应用系统维护
     */
    @PreAuthorize("@ss.hasPermi('system:yyxtwh:edit')")
    @Log(title = "经验共享-应用系统维护", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody JygxYyxtwh jygxYyxtwh)
    {
        return toAjax(jygxYyxtwhService.updateJygxYyxtwh(jygxYyxtwh));
    }

    /**
     * 删除经验共享-应用系统维护
     */
    @PreAuthorize("@ss.hasPermi('system:yyxtwh:remove')")
    @Log(title = "经验共享-应用系统维护", businessType = BusinessType.DELETE)
	@DeleteMapping("/{yyxtids}")
    public AjaxResult remove(@PathVariable Long[] yyxtids)
    {
        return toAjax(jygxYyxtwhService.deleteJygxYyxtwhByYyxtids(yyxtids));
    }
}
