package com.qianhe.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.qianhe.domain.JygxWzgl;
import com.qianhe.service.IJygxWzglService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;

import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 经验共享-文章管理Controller
 *
 * @author qianhe
 * @date 2024-07-29
 */
@RestController
@RequestMapping("/system/wzgl")
public class JygxWzglController extends BaseController
{
    @Autowired
    private IJygxWzglService jygxWzglService;

    /**
     * 查询经验共享-文章管理列表
     */
    @PreAuthorize("@ss.hasPermi('system:wzgl:list')")
    @GetMapping("/list")
    public TableDataInfo list(JygxWzgl jygxWzgl)
    {
        startPage();
        List<JygxWzgl> list = jygxWzglService.selectJygxWzglList(jygxWzgl);
        return getDataTable(list);
    }




    /**
     * 查询经验共享-首页轮播图新闻
     */
    @GetMapping("/sylbxlist")
    public TableDataInfo sylbxlist(JygxWzgl jygxWzgl)
    {
        startPage();
        List<JygxWzgl> list = jygxWzglService.selectSylbxwList(jygxWzgl);
        return getDataTable(list);
    }



    /**
     * 查询经验共享-文章管理列表(白名单)
     */
    @GetMapping("/listbmd")
    public TableDataInfo listbmd(JygxWzgl jygxWzgl)
    {
        startPage();
        List<JygxWzgl> list = jygxWzglService.selectJygxWzglList(jygxWzgl);
        return getDataTable(list);
    }



    /**
     * 查询经验共享-首页轮播图新闻(白名单)
     */
    @GetMapping("/sylbxlistbmd")
    public TableDataInfo sylbxlistbmd(JygxWzgl jygxWzgl)
    {
        startPage();
        List<JygxWzgl> list = jygxWzglService.selectSylbxwList(jygxWzgl);
        return getDataTable(list);
    }
    /**
     * 导出经验共享-文章管理列表
     */
    @PreAuthorize("@ss.hasPermi('system:wzgl:export')")
    @Log(title = "经验共享-文章管理", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, JygxWzgl jygxWzgl)
    {
        List<JygxWzgl> list = jygxWzglService.selectJygxWzglList(jygxWzgl);
        ExcelUtil<JygxWzgl> util = new ExcelUtil<JygxWzgl>(JygxWzgl.class);
        util.exportExcel(response, list, "经验共享-文章管理数据");
    }

    /**
     * 获取经验共享-文章管理详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:wzgl:query')")
    @GetMapping(value = "/{wzid}")
    public AjaxResult getInfo(@PathVariable("wzid") Long wzid)
    {
        return success(jygxWzglService.selectJygxWzglByWzid(wzid));
    }


    /**
     * 新增经验共享-文章管理
     */
    @PreAuthorize("@ss.hasPermi('system:wzgl:add')")
    @Log(title = "经验共享-文章管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody JygxWzgl jygxWzgl)
    {
        return toAjax(jygxWzglService.insertJygxWzgl(jygxWzgl));
    }


    /**
     * 新增首页轮播新闻
     */
    @PostMapping("/addxw")
    public AjaxResult addxw(@RequestBody JygxWzgl jygxWzgl)
    {
        return toAjax(jygxWzglService.insertxw(jygxWzgl));
    }

    /**
     * 修改经验共享-文章管理
     */
    @PreAuthorize("@ss.hasAnyPermi('system:wzgl:editld,system:wzgl:edit')")
    @Log(title = "经验共享-文章管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody JygxWzgl jygxWzgl)
    {
        return toAjax(jygxWzglService.updateJygxWzgl(jygxWzgl));
    }

    /**
     * 修改经验共享-提交按钮
     */
    @PutMapping("/tj")
    public AjaxResult tj(@RequestBody JygxWzgl jygxWzgl)
    {
        return toAjax(jygxWzglService.updatetj(jygxWzgl));
    }




    /**
     * 文章管理审核
     */
    @PreAuthorize("@ss.hasPermi('system:wzgl:wzglsh')")
    @Log(title = "文章管理审核", businessType = BusinessType.UPDATE)
    @PutMapping("/wzglsh")
    public AjaxResult wzglsh(@RequestBody JygxWzgl jygxWzgl)
    {
        return toAjax(jygxWzglService.updateJygxWzgl(jygxWzgl));
    }


    /**
     * 删除经验共享-文章管理
     */
    @PreAuthorize("@ss.hasAnyPermi('system:wzgl:remove,system:wzgl:removeld')")
    @Log(title = "经验共享-文章管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{wzids}")
    public AjaxResult remove(@PathVariable Long[] wzids)
    {
        return toAjax(jygxWzglService.deleteJygxWzglByWzids(wzids));
    }



    /**
     *数据置顶
     */
    @GetMapping("/getwzzd")
    public AjaxResult getwzzd(JygxWzgl jygxWzgl)
    {
        return toAjax(jygxWzglService.updatewzzd(jygxWzgl));
    }

    /**
     *取消置顶
     */
    @GetMapping("/getqxzd")
    public AjaxResult getqxzd(JygxWzgl jygxWzgl)
    {
        return toAjax(jygxWzglService.updateqxzd(jygxWzgl));
    }
}
