package com.qianhe.service.impl;

import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.domain.SjGfjsZsdwfjxcj;
import com.qianhe.mapper.SjGfjsZsdwfjxcjMapper;
import com.qianhe.service.ISjGfjsZsdwfjxcjService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 规范建设-直属单位否决项采集Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-24
 */
@Service
public class SjGfjsZsdwfjxcjServiceImpl implements ISjGfjsZsdwfjxcjService
{
    @Autowired
    private SjGfjsZsdwfjxcjMapper sjGfjsZsdwfjxcjMapper;

    /**
     * 查询规范建设-直属单位否决项采集
     *
     * @param id 规范建设-直属单位否决项采集主键
     * @return 规范建设-直属单位否决项采集
     */
    @Override
    public SjGfjsZsdwfjxcj selectSjGfjsZsdwfjxcjById(Long id)
    {
        return sjGfjsZsdwfjxcjMapper.selectSjGfjsZsdwfjxcjById(id);
    }

    /**
     * 查询规范建设-直属单位否决项采集列表
     *
     * @param sjGfjsZsdwfjxcj 规范建设-直属单位否决项采集
     * @return 规范建设-直属单位否决项采集
     */
    @Override
    @DataScope(deptAlias = "c")
    public List<SjGfjsZsdwfjxcj> selectSjGfjsZsdwfjxcjList(SjGfjsZsdwfjxcj sjGfjsZsdwfjxcj)
    {
        return sjGfjsZsdwfjxcjMapper.selectSjGfjsZsdwfjxcjList(sjGfjsZsdwfjxcj);
    }

    /**
     * 新增规范建设-直属单位否决项采集
     *
     * @param sjGfjsZsdwfjxcj 规范建设-直属单位否决项采集
     * @return 结果
     */
    @Override
    public int insertSjGfjsZsdwfjxcj(SjGfjsZsdwfjxcj sjGfjsZsdwfjxcj)
    {
        sjGfjsZsdwfjxcj.setCreateTime(DateUtils.getNowDate());
        sjGfjsZsdwfjxcj.setCreateBy(SecurityUtils.getUsername());
        return sjGfjsZsdwfjxcjMapper.insertSjGfjsZsdwfjxcj(sjGfjsZsdwfjxcj);
    }

    /**
     * 修改规范建设-直属单位否决项采集
     *
     * @param sjGfjsZsdwfjxcj 规范建设-直属单位否决项采集
     * @return 结果
     */
    @Override
    public int updateSjGfjsZsdwfjxcj(SjGfjsZsdwfjxcj sjGfjsZsdwfjxcj)
    {
        sjGfjsZsdwfjxcj.setUpdateTime(DateUtils.getNowDate());
        sjGfjsZsdwfjxcj.setUpdateBy(SecurityUtils.getUsername());
        return sjGfjsZsdwfjxcjMapper.updateSjGfjsZsdwfjxcj(sjGfjsZsdwfjxcj);
    }

    /**
     * 批量删除规范建设-直属单位否决项采集
     *
     * @param ids 需要删除的规范建设-直属单位否决项采集主键
     * @return 结果
     */
    @Override
    public int deleteSjGfjsZsdwfjxcjByIds(Long[] ids)
    {
        return sjGfjsZsdwfjxcjMapper.deleteSjGfjsZsdwfjxcjByIds(ids);
    }

    /**
     * 删除规范建设-直属单位否决项采集信息
     *
     * @param id 规范建设-直属单位否决项采集主键
     * @return 结果
     */
    @Override
    public int deleteSjGfjsZsdwfjxcjById(Long id)
    {
        return sjGfjsZsdwfjxcjMapper.deleteSjGfjsZsdwfjxcjById(id);
    }

    @Override
    public int batchSave(List<SjGfjsZsdwfjxcj> list) {
        return sjGfjsZsdwfjxcjMapper.batchSave(list);
    }

    //批量修改 根据ids
    @Override
    public int plxg(SjGfjsZsdwfjxcj fjx) {
        fjx.setUpdateTime(DateUtils.getNowDate());
        fjx.setUpdateBy(SecurityUtils.getUsername());
        return sjGfjsZsdwfjxcjMapper.plxg(fjx);
    }

}
