package com.qianhe.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;

/**
 * 文档-文档信息对象 wd_wdxx
 *
 * @author qianhe
 * @date 2024-02-28
 */
public class WdWdxx extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 关联id */
    @Excel(name = "关联id")
    private String glId;

    /** 附件名称 */
    @Excel(name = "附件名称")
    private String fjmc;

    /** 附件地址 */
    @Excel(name = "附件地址")
    private String fjdz;

    /** 模块名称 */
    @Excel(name = "模块名称")
    private String mkmc;

    /** 附件类型 */
    @Excel(name = "附件类型")
    private String fjlx;

    /** 录入人 */
    @Excel(name = "录入人")
    private String lrr;

    /** 录入时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "录入时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date lrsj;

    /** 修改人 */
    @Excel(name = "修改人")
    private String xgr;

    /** 修改时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "修改时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date xgsj;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 预留1 */
    @Excel(name = "预留1")
    private String yl1;

    /** 预留2 */
    @Excel(name = "预留2")
    private String yl2;

    /** 预留3 */
    @Excel(name = "预留3")
    private String yl3;

    /** 预留4 */
    @Excel(name = "预留4")
    private String yl4;

    /** 预留5 */
    @Excel(name = "预留5")
    private String yl5;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setGlId(String glId)
    {
        this.glId = glId;
    }

    public String getGlId()
    {
        return glId;
    }
    public void setFjmc(String fjmc)
    {
        this.fjmc = fjmc;
    }

    public String getFjmc()
    {
        return fjmc;
    }
    public void setFjdz(String fjdz)
    {
        this.fjdz = fjdz;
    }

    public String getFjdz()
    {
        return fjdz;
    }
    public void setMkmc(String mkmc)
    {
        this.mkmc = mkmc;
    }

    public String getMkmc()
    {
        return mkmc;
    }
    public void setFjlx(String fjlx)
    {
        this.fjlx = fjlx;
    }

    public String getFjlx()
    {
        return fjlx;
    }
    public void setLrr(String lrr)
    {
        this.lrr = lrr;
    }

    public String getLrr()
    {
        return lrr;
    }
    public void setLrsj(Date lrsj)
    {
        this.lrsj = lrsj;
    }

    public Date getLrsj()
    {
        return lrsj;
    }
    public void setXgr(String xgr)
    {
        this.xgr = xgr;
    }

    public String getXgr()
    {
        return xgr;
    }
    public void setXgsj(Date xgsj)
    {
        this.xgsj = xgsj;
    }

    public Date getXgsj()
    {
        return xgsj;
    }
    public void setBz(String bz)
    {
        this.bz = bz;
    }

    public String getBz()
    {
        return bz;
    }
    public void setYl1(String yl1)
    {
        this.yl1 = yl1;
    }

    public String getYl1()
    {
        return yl1;
    }
    public void setYl2(String yl2)
    {
        this.yl2 = yl2;
    }

    public String getYl2()
    {
        return yl2;
    }
    public void setYl3(String yl3)
    {
        this.yl3 = yl3;
    }

    public String getYl3()
    {
        return yl3;
    }
    public void setYl4(String yl4)
    {
        this.yl4 = yl4;
    }

    public String getYl4()
    {
        return yl4;
    }
    public void setYl5(String yl5)
    {
        this.yl5 = yl5;
    }

    public String getYl5()
    {
        return yl5;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("glId", getGlId())
            .append("fjmc", getFjmc())
            .append("fjdz", getFjdz())
            .append("mkmc", getMkmc())
            .append("fjlx", getFjlx())
            .append("lrr", getLrr())
            .append("lrsj", getLrsj())
            .append("xgr", getXgr())
            .append("xgsj", getXgsj())
            .append("bz", getBz())
            .append("yl1", getYl1())
            .append("yl2", getYl2())
            .append("yl3", getYl3())
            .append("yl4", getYl4())
            .append("yl5", getYl5())
            .toString();
    }
}
