package com.qianhe.controller;

import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.domain.entity.SysDept;
import com.qianhe.common.core.page.TableDataInfo;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.common.exception.BusinessException;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.domain.SjZdbfKhpjbzCb;
import com.qianhe.domain.SjZdbfZsdwwtcj;
import com.qianhe.mapper.SjZdbfKhpjbzMapper;
import com.qianhe.service.ISjZdbfbfzjcService;
import com.qianhe.service.ISjZdbfjgbmjcService;
import com.qianhe.system.mapper.SysDeptMapper;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 指导帮扶-机关部门检查Controller
 *
 * @author qianhe
 * @date 2024-07-23
 */
@RestController
@RequestMapping("/system/sjZdbfjgbmjc")
public class SjZdbfjgbmjcController extends BaseController
{
    @Autowired
    private ISjZdbfjgbmjcService sjZdbfJcdwwtcjService;
    @Autowired
    private SysDeptMapper sysDeptMapper;
    @Autowired
    private SjZdbfKhpjbzMapper sjZdbfKhpjbzMapper;
    /**
     * 查询指导帮扶-机关部门检查列表
     */
    @PreAuthorize("@ss.hasPermi('system:sjZdbfjgbmjc:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjZdbfZsdwwtcj sjZdbfZsdwwtcj)
    {
        sjZdbfZsdwwtcj.setJcjb("机关部门检查");
        startPage();
        List<SjZdbfZsdwwtcj> list = sjZdbfJcdwwtcjService.selectSjZdbfZsdwwtcjList(sjZdbfZsdwwtcj);
        return getDataTable(list);
    }

    /**
     * 导出指导帮扶-机关部门检查列表
     */
    @PreAuthorize("@ss.hasPermi('system:sjZdbfjgbmjc:export')")
    @Log(title = "指导帮扶-机关部门检查", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjZdbfZsdwwtcj sjZdbfZsdwwtcj)
    {
        Workbook exl = null;
        OutputStream out = null;
        InputStream in  = null;
        try {
            in =this.getClass().getResourceAsStream("/static/jgbmwtjc.xlsx");
            exl = WorkbookFactory.create(in);
            out = response.getOutputStream();
            response.reset();
            String filename = URLEncoder.encode("机关部门检查模板.xlsx", "UTF-8");
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + filename);
            response.setContentType(MediaType.APPLICATION_OCTET_STREAM_VALUE);
            exl.write(out);
            exl.close();
        }catch(Exception e){
            e.getMessage();
            throw new BusinessException("导出Excel失败，请联系网站管理员！");
        }finally{
            if (exl != null) {
                try {
                    exl.close();
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }

    }

    /**
     * 获取指导帮扶-机关部门检查详细信息
     */
//    @PreAuthorize("@ss.hasPermi('system:sjZdbfjgbmjc:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjZdbfJcdwwtcjService.selectSjZdbfZsdwwtcjById(id));
    }

    /**
     * 新增指导帮扶-机关部门检查
     */
    @PreAuthorize("@ss.hasPermi('system:sjZdbfjgbmjc:add')")
    @Log(title = "指导帮扶-机关部门检查", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjZdbfZsdwwtcj sjZdbfZsdwwtcj)
    {
        sjZdbfZsdwwtcj.setJcjb("机关部门检查");
        return toAjax(sjZdbfJcdwwtcjService.insertSjZdbfZsdwwtcj(sjZdbfZsdwwtcj));
    }

    /**
     * 修改指导帮扶-机关部门检查
     */
    @PreAuthorize("@ss.hasPermi('system:sjZdbfjgbmjc:edit')")
    @Log(title = "指导帮扶-机关部门检查", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjZdbfZsdwwtcj sjZdbfZsdwwtcj)
    {
        sjZdbfZsdwwtcj.setJcjb("机关部门检查");
        return toAjax(sjZdbfJcdwwtcjService.updateSjZdbfZsdwwtcj(sjZdbfZsdwwtcj));
    }

    /**
     * 删除指导帮扶-机关部门检查
     */
    @PreAuthorize("@ss.hasPermi('system:sjZdbfjgbmjc:remove')")
    @Log(title = "指导帮扶-机关部门检查", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {

        return toAjax(sjZdbfJcdwwtcjService.deleteSjZdbfZsdwwtcjByIds(ids));
    }


    @PreAuthorize("@ss.hasPermi('system:sjZdbfjgbmjc:importData')")
    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file, boolean updateSupport) throws Exception{

        XSSFWorkbook workbook = null;
        List<SysDept> deptList = sysDeptMapper.selectDeptList(new SysDept());

        try {
            //装载流
            workbook = new XSSFWorkbook(file.getInputStream());

            // 获取一个工作表，下标从0开始
            XSSFSheet sheet = workbook.getSheetAt(0);
            int lastRowNum = sheet.getLastRowNum();
            List<SjZdbfZsdwwtcj> list=new ArrayList<>();
            // 通过循环，逐行取出表中每行数据
            for(int i=0;i<=lastRowNum;i++) {//跳过第一行和第二行
                if(i==0 || i==1){
                    continue;
                }
                // 获取行
                XSSFRow row = sheet.getRow(i);
                SjZdbfZsdwwtcj zsdwwtcj=new SjZdbfZsdwwtcj();
                System.out.println(row);
                //日期
                String rq=new DataFormatter().formatCellValue(row.getCell(1));
                if(StringUtils.isEmpty(rq)){
                    return AjaxResult.error("导入失败，第"+(i+1)+"行日期不能为空");
                }

                Date date = DateUtils.parseDate(rq);
                if(date==null){
                    return AjaxResult.error("导入失败，第"+(i+1)+"行日期格式错误");
                }
                zsdwwtcj.setRq(DateUtils.parseDateToStr("yyyy-MM",date));

                //机关部门
                String jgbm=new DataFormatter().formatCellValue(row.getCell(2)) ;
                if(StringUtils.isEmpty(jgbm)){
                    return AjaxResult.error("导入失败，第"+(i+1)+"行机关部门不能为空");
                }
                String[] jgsplit = jgbm.split("/");
                if(jgsplit.length==1){
                    String bm=jgsplit[0]; // 部门
                    SysDept bmdept = deptList.stream().filter(dept -> dept.getDeptName().equals(bm)).findFirst().orElse(null);
                    if(bmdept==null){
                        return AjaxResult.error("导入失败，第"+(i+1)+"行，机关部门：未匹配到机关名称");
                    }
                    zsdwwtcj.setYl3(bmdept.getDeptId());
                }else{
                    String bm=jgsplit[0];// 部门
                    String ks=jgsplit[1];// 科室
                    SysDept bmdept = deptList.stream().filter(dept -> dept.getDeptName().equals(bm)).findFirst().orElse(null);
                    if(bmdept==null){
                        return AjaxResult.error("导入失败，第"+(i+1)+"行，机关部门：未匹配到机关名称");
                    }
                    SysDept ksdept = deptList.stream().filter(dept -> dept.getDeptName().equals(ks) && dept.getParentId().equals(bmdept.getDeptId())).findFirst().orElse(null);
                    if(ksdept==null){
                        return AjaxResult.error("导入失败，第"+(i+1)+"行，机关部门：未匹配到科室名称");
                    }
                    zsdwwtcj.setYl3(ksdept.getDeptId());
                }


                //受检单位
                String dw=new DataFormatter().formatCellValue(row.getCell(3)) ;
                if(StringUtils.isEmpty(dw)){
                    return AjaxResult.error("导入失败，第"+(i+1)+"行受检单位不能为空");
                }
                //查询受检单位id
                String[] split = dw.split("/");
                if(split.length<2){
                    return AjaxResult.error("导入失败，第"+(i+1)+"行输入的受检单位格式有误!");
                }
                String ejdw=split[0];
                SysDept ejdept = deptList.stream().filter(dept -> dept.getDeptName().equals(ejdw)).findFirst().orElse(null);
                if(ejdept==null){
                    return AjaxResult.error("导入失败，第"+(i+1)+"行，受检单位：未匹配到二级单位");
                }
                String sjdw=split[1];
                SysDept sjdept = deptList.stream().filter(dept -> dept.getDeptName().equals(sjdw) && dept.getParentId().equals(ejdept.getDeptId())).findFirst().orElse(null);
                if(sjdept==null){
                    return AjaxResult.error("导入失败，第"+(i+1)+"行，受检单位：未匹配到三级单位");
                }
                zsdwwtcj.setDeptId(sjdept.getDeptId());
                //问题描述
                String wtms=new DataFormatter().formatCellValue(row.getCell(4)) ;
                if(StringUtils.isEmpty(wtms)){
                    return AjaxResult.error("导入失败，第"+(i+1)+"行问题描述不能为空");
                }
                zsdwwtcj.setWtmc(wtms);
                //考核内容
                String khnr=new DataFormatter().formatCellValue(row.getCell(5)) ;
                if(StringUtils.isEmpty(khnr)){
                    return AjaxResult.error("导入失败，第"+(i+1)+"行考核内容不能为空");
                }
                zsdwwtcj.setKhnr(khnr);
                //考核项点
                String khxd=new DataFormatter().formatCellValue(row.getCell(6)) ;
                if(StringUtils.isEmpty(khxd)){
                    return AjaxResult.error("导入失败，第"+(i+1)+"行考核项点不能为空");
                }
                zsdwwtcj.setKhxd(khxd);
                String pjbz=new DataFormatter().formatCellValue(row.getCell(7)) ;
                if(StringUtils.isEmpty(pjbz)){
                    return AjaxResult.error("导入失败，第"+(i+1)+"行评价标准不能为空");
                }
                //匹配评价标准
                String substring = pjbz.substring(4);
                long l = Long.parseLong(substring);
                SjZdbfKhpjbzCb sjZdbfKhpjbzCb=new SjZdbfKhpjbzCb();
                sjZdbfKhpjbzCb.setKhxd(khxd);
                sjZdbfKhpjbzCb.setKhnr(khnr);
                sjZdbfKhpjbzCb.setLx(sjdept.getDeptLx());
                if(StringUtils.isEmpty(sjdept.getDeptLx())){
                    return AjaxResult.error("导入失败，第"+(i+1)+"行单位未设置类型");
                }
                sjZdbfKhpjbzCb.setPx(l);
                sjZdbfKhpjbzCb.setNd(rq.substring(0,4));
                SjZdbfKhpjbzCb cb=sjZdbfKhpjbzMapper.selectSjZdbfKhpjbzCb(sjZdbfKhpjbzCb);
                if(cb==null){
                    return AjaxResult.error("导入失败，第"+(i+1)+"行未匹配到评价标准");
                }
                zsdwwtcj.setPjbzid(cb.getId()+"");
                zsdwwtcj.setPjbzmc(cb.getPjbz());
                String zgzrr=new DataFormatter().formatCellValue(row.getCell(8)) ;
                zsdwwtcj.setZgzrr(zgzrr);
                String zgcs=new DataFormatter().formatCellValue(row.getCell(9)) ;
                zsdwwtcj.setZgcs(zgcs);
                String zgqx=new DataFormatter().formatCellValue(row.getCell(10)) ;
                zsdwwtcj.setZgqx(zgqx);
                String zgzt=new DataFormatter().formatCellValue(row.getCell(11)) ;
                zsdwwtcj.setZgzt(zgzt);
                zsdwwtcj.setJcjb("机关部门检查");
                zsdwwtcj.setCreateTime(DateUtils.getNowDate());
                zsdwwtcj.setCreateBy(SecurityUtils.getUsername());
                list.add(zsdwwtcj);
            }
            if(list.size()>0){
                sjZdbfJcdwwtcjService.batchSave(list);
            }
        } catch (IOException e) {
            e.getMessage();
            e.printStackTrace();
            throw new BusinessException("导入Excel失败，请联系网站管理员！");

        } finally {
            workbook.close();
        }
        return AjaxResult.success("导入成功");
    }




}
