package com.qianhe.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.qianhe.domain.BzscYsjglggzsc;
import com.qianhe.service.IBzscYsjglggzscService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;

import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 标准手册-油水井管理岗工作手册-总Controller
 *
 * @author qianhe
 * @date 2024-10-09
 */
@RestController
@RequestMapping("/system/ysjglggzsc")
public class BzscYsjglggzscController extends BaseController
{
    @Autowired
    private IBzscYsjglggzscService bzscYsjglggzscService;

    /**
     * 查询标准手册-油水井管理岗工作手册-总列表
     */
    @PreAuthorize("@ss.hasPermi('system:ysjglggzsc:list')")
    @GetMapping("/list")
    public TableDataInfo list(BzscYsjglggzsc bzscYsjglggzsc)
    {
        startPage();
        List<BzscYsjglggzsc> list = bzscYsjglggzscService.selectBzscYsjglggzscList(bzscYsjglggzsc);
        return getDataTable(list);
    }

    /**
     * 导出标准手册-油水井管理岗工作手册-总列表
     */
    @PreAuthorize("@ss.hasPermi('system:ysjglggzsc:export')")
    @Log(title = "标准手册-油水井管理岗工作手册-总", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, BzscYsjglggzsc bzscYsjglggzsc)
    {
        List<BzscYsjglggzsc> list = bzscYsjglggzscService.selectBzscYsjglggzscList(bzscYsjglggzsc);
        ExcelUtil<BzscYsjglggzsc> util = new ExcelUtil<BzscYsjglggzsc>(BzscYsjglggzsc.class);
        util.exportExcel(response, list, "标准手册-油水井管理岗工作手册-总数据");
    }

    /**
     * 获取标准手册-油水井管理岗工作手册-总详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:ysjglggzsc:query')")
    @GetMapping(value = "/{ID}")
    public AjaxResult getInfo(@PathVariable("ID") Long ID)
    {
        return success(bzscYsjglggzscService.selectBzscYsjglggzscByID(ID));
    }

    /**
     * 新增标准手册-油水井管理岗工作手册-总
     */
    @PreAuthorize("@ss.hasPermi('system:ysjglggzsc:add')")
    @Log(title = "标准手册-油水井管理岗工作手册-总", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BzscYsjglggzsc bzscYsjglggzsc)
    {
        return toAjax(bzscYsjglggzscService.insertBzscYsjglggzsc(bzscYsjglggzsc));
    }

    /**
     * 修改标准手册-油水井管理岗工作手册-总
     */
    @PreAuthorize("@ss.hasPermi('system:ysjglggzsc:edit')")
    @Log(title = "标准手册-油水井管理岗工作手册-总", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BzscYsjglggzsc bzscYsjglggzsc)
    {
        return toAjax(bzscYsjglggzscService.updateBzscYsjglggzsc(bzscYsjglggzsc));
    }

    /**
     * 删除标准手册-油水井管理岗工作手册-总
     */
    @PreAuthorize("@ss.hasPermi('system:ysjglggzsc:remove')")
    @Log(title = "标准手册-油水井管理岗工作手册-总", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ID}")
    public AjaxResult remove(@PathVariable Long ID)
    {
        return toAjax(bzscYsjglggzscService.deleteBzscYsjglggzscByID(ID));
    }
}
