package com.qianhe.mapper;

import com.qianhe.domain.JygxWzgl;
import com.qianhe.domain.JygxWzglfj;
import com.qianhe.domain.Ssfl;
import org.apache.ibatis.annotations.Param;

import java.util.List;


/**
 * 经验共享-文章管理Mapper接口
 *
 * @author qianhe
 * @date 2024-07-29
 */
public interface JygxWzglMapper
{
    /**
     * 查询经验共享-文章管理
     *
     * @param wzid 经验共享-文章管理主键
     * @return 经验共享-文章管理
     */
    public JygxWzgl selectJygxWzglByWzid(Long wzid);

    /**
     * 查询经验共享-文章管理列表
     *
     * @param jygxWzgl 经验共享-文章管理
     * @return 经验共享-文章管理集合
     */
    public List<JygxWzgl> selectJygxWzglList(JygxWzgl jygxWzgl);

    /**
     * 查询经验共享-文章管理列表
     *
     * @param jygxWzgl 经验共享-文章管理
     * @return 经验共享-文章管理集合
     */
    public List<JygxWzgl> selectList(JygxWzgl jygxWzgl);

    /**
     * 查询经验共享-首页轮播图新闻
     *
     * @param jygxWzgl
     * @return
     */
    public List<JygxWzgl> selectSylbxwList(JygxWzgl jygxWzgl);

    /**
     * 新增经验共享-文章管理
     *
     * @param jygxWzgl 经验共享-文章管理
     * @return 结果
     */
    public int insertJygxWzgl(JygxWzgl jygxWzgl);

    /**
     * 修改经验共享-文章管理
     *
     * @param jygxWzgl 经验共享-文章管理
     * @return 结果
     */
    public int updateJygxWzgl(JygxWzgl jygxWzgl);

    /**
     * 取消置顶
     */
    public int updateqxzd(JygxWzgl jygxWzgl);


    /**
     * 阅读数量
     */
    public int update(JygxWzgl jygxWzgl);

    /**
     * 数据置顶
     */
    public int updatezd(JygxWzgl jygxWzgl);



    /**
     * 删除经验共享-文章管理
     *
     * @param wzid 经验共享-文章管理主键
     * @return 结果
     */
    public int deleteJygxWzglByWzid(Long wzid);

    /**
     * 批量删除经验共享-文章管理
     *
     * @param wzids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteJygxWzglByWzids(Long[] wzids);


    /**
     * 查询附件
     * @param wzid
     * @return
     */
    List<JygxWzglfj> selectFile(@Param("wzid") Long wzid);

    /**
     * 批量新增附件
     */
    int insertFile(List<JygxWzglfj> list);

    /**
     * 根据附件id删除附件信息
     * @param wzid
     */
    void deleteFileByBusinessId(@Param("wzid") Long wzid);


    /**
     * 首页搜索类型条数
     */
    public List<Ssfl> selectcxflList(JygxWzgl jygxWzgl);

    /**
     * 首页搜索
     */
    public List<JygxWzgl> selectsyssList(JygxWzgl jygxWzgl);

}
