package com.qianhe.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;

/**
 * 经验共享-超链接维护对象 jygx_cljwh
 *
 * @author qianhe
 * @date 2024-07-30
 */
public class JygxCljwh extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long cljid;

    /** 排序 */
    @Excel(name = "排序")
    private Long px;

    /** 名称标题 */
    @Excel(name = "名称标题")
    private String mcbt;

    /** 连接 */
    @Excel(name = "连接")
    private String lj;

    /** 预留1 */
    @Excel(name = "预留1")
    private String yl1;

    /** 预留2 */
    @Excel(name = "预留2")
    private String yl2;

    /** 预留3 */
    @Excel(name = "预留3")
    private String yl3;

    /** 预留4 */
    @Excel(name = "预留4")
    private String yl4;

    /** 预留5 */
    @Excel(name = "预留5")
    private String yl5;

    /** 跳转方式（新页签，当前页） */
    @Excel(name = "跳转方式", readConverterExp = "新=页签，当前页")
    private String tzfs;

    /** 发布状态（3未发布/4发布） */
    @Excel(name = "发布状态", readConverterExp = "3=未发布/4发布")
    private String fbzt;

    public void setCljid(Long cljid)
    {
        this.cljid = cljid;
    }

    public Long getCljid()
    {
        return cljid;
    }
    public void setPx(Long px)
    {
        this.px = px;
    }

    public Long getPx()
    {
        return px;
    }
    public void setMcbt(String mcbt)
    {
        this.mcbt = mcbt;
    }

    public String getMcbt()
    {
        return mcbt;
    }
    public void setLj(String lj)
    {
        this.lj = lj;
    }

    public String getLj()
    {
        return lj;
    }
    public void setYl1(String yl1)
    {
        this.yl1 = yl1;
    }

    public String getYl1()
    {
        return yl1;
    }
    public void setYl2(String yl2)
    {
        this.yl2 = yl2;
    }

    public String getYl2()
    {
        return yl2;
    }
    public void setYl3(String yl3)
    {
        this.yl3 = yl3;
    }

    public String getYl3()
    {
        return yl3;
    }
    public void setYl4(String yl4)
    {
        this.yl4 = yl4;
    }

    public String getYl4()
    {
        return yl4;
    }
    public void setYl5(String yl5)
    {
        this.yl5 = yl5;
    }

    public String getYl5()
    {
        return yl5;
    }
    public void setTzfs(String tzfs)
    {
        this.tzfs = tzfs;
    }

    public String getTzfs()
    {
        return tzfs;
    }
    public void setFbzt(String fbzt)
    {
        this.fbzt = fbzt;
    }

    public String getFbzt()
    {
        return fbzt;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("cljid", getCljid())
            .append("px", getPx())
            .append("mcbt", getMcbt())
            .append("lj", getLj())
            .append("yl1", getYl1())
            .append("yl2", getYl2())
            .append("yl3", getYl3())
            .append("yl4", getYl4())
            .append("yl5", getYl5())
            .append("tzfs", getTzfs())
            .append("fbzt", getFbzt())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .toString();
    }
}
