package com.qianhe.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.domain.WdWdxx;
import com.qianhe.service.IWdWdxxService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 文档-文档信息Controller
 *
 * @author qianhe
 * @date 2024-02-28
 */
@RestController
@RequestMapping("/system/wdWdxx")
public class WdWdxxController extends BaseController
{
    @Autowired
    private IWdWdxxService wdWdxxService;

    /**
     * 查询文档-文档信息列表
     */
    @PreAuthorize("@ss.hasPermi('system:wdWdxx:list')")
    @GetMapping("/list")
    public TableDataInfo list(WdWdxx wdWdxx)
    {
        startPage();
        List<WdWdxx> list = wdWdxxService.selectWdWdxxList(wdWdxx);
        return getDataTable(list);
    }

    /**
     * 导出文档-文档信息列表
     */
    @PreAuthorize("@ss.hasPermi('system:wdWdxx:export')")
    @Log(title = "文档-文档信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, WdWdxx wdWdxx)
    {
        List<WdWdxx> list = wdWdxxService.selectWdWdxxList(wdWdxx);
        ExcelUtil<WdWdxx> util = new ExcelUtil<WdWdxx>(WdWdxx.class);
        util.exportExcel(response, list, "文档-文档信息数据");
    }

    /**
     * 获取文档-文档信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:wdWdxx:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(wdWdxxService.selectWdWdxxById(id));
    }

    /**
     * 新增文档-文档信息
     */
    @PreAuthorize("@ss.hasPermi('system:wdWdxx:add')")
    @Log(title = "文档-文档信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody WdWdxx wdWdxx)
    {
        return toAjax(wdWdxxService.insertWdWdxx(wdWdxx));
    }

    /**
     * 修改文档-文档信息
     */
    @PreAuthorize("@ss.hasPermi('system:wdWdxx:edit')")
    @Log(title = "文档-文档信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody WdWdxx wdWdxx)
    {
        return toAjax(wdWdxxService.updateWdWdxx(wdWdxx));
    }

    /**
     * 删除文档-文档信息
     */
    @PreAuthorize("@ss.hasPermi('system:wdWdxx:remove')")
    @Log(title = "文档-文档信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(wdWdxxService.deleteWdWdxxByIds(ids));
    }
}
