package com.qianhe.domain;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;

/**
 * 班组信息对象 sj_bzxx
 *
 * @author qianhe
 * @date 2025-08-04
 */
@Data
public class SjBzxx extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 单位id */
    private Long deptId;

    @Excel(name = "单位名称")
    private String deptName;

    /** 基层班组 班组名称 */
    @Excel(name = "班组名称")
    private String bzmc;

    /** 基层班站分类 班组类型 */
    @Excel(name = "班组类型")
    private String bzlx;

    /** 全部用工人数 */
    @Excel(name = "人数")
    private String rs;

    /** 状态 0 未提交 1 已提交 */
    @Excel(name = "状态 0 未提交 1 已提交")
    private String zt;



    //查询出的结果

    private String bzzs;//班组总数
    private String zrs;//总人数

    //传入参数
    private String ids;//批量ids 例如6,7,8 只有一个传入6

    private String zsdw;//直属单位
    private String zsdwfl;//直属单位分类
    private String zsdwRowSpan;//直属单位 合并单元格 行数量 合并几行的单元格
    private String zsdwIsFirst;//直属单位 内部 是否是第一条 第一条合并单元格 其他条 不显示
    private String jcdw;//基层单位
    private String jcdwfl;//基层单位分类
    private String jcdwRowSpan;//基层单位 合并单元格 行数量 合并几行的单元格
    private String jcdwIsFirst;//基层单位 内部 是否是第一条 第一条合并单元格 其他条 不显示

    private String bzsl1;//管理类班组（室中心）数量
    private String bzsl2;//一线生产班组数量
    private String bzsl3;//研究类班组（室中心）数量
    private String bzsl4;//后勤服务类班组数量
    private String bzsl5;//其他
    private String ygrsxj;//用工人数小计




}
