package com.qianhe.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.qianhe.mapper.SjGfjsFdgzMapper;
import com.qianhe.domain.SjGfjsFdgz;
import com.qianhe.service.ISjGfjsFdgzService;

/**
 * 单位分档规则Service业务层处理
 *
 * @author qianhe
 * @date 2025-08-15
 */
@Service
public class SjGfjsFdgzServiceImpl implements ISjGfjsFdgzService
{
    @Autowired
    private SjGfjsFdgzMapper sjGfjsFdgzMapper;

    /**
     * 查询单位分档规则
     *
     * @param id 单位分档规则主键
     * @return 单位分档规则
     */
    @Override
    public SjGfjsFdgz selectSjGfjsFdgzById(Long id)
    {
        return sjGfjsFdgzMapper.selectSjGfjsFdgzById(id);
    }

    /**
     * 查询单位分档规则列表
     *
     * @param sjGfjsFdgz 单位分档规则
     * @return 单位分档规则
     */
    @Override
    public List<SjGfjsFdgz> selectSjGfjsFdgzList(SjGfjsFdgz sjGfjsFdgz)
    {
        return sjGfjsFdgzMapper.selectSjGfjsFdgzList(sjGfjsFdgz);
    }

    /**
     * 新增单位分档规则
     *
     * @param sjGfjsFdgz 单位分档规则
     * @return 结果
     */
    @Override
    public int insertSjGfjsFdgz(SjGfjsFdgz sjGfjsFdgz)
    {
        return sjGfjsFdgzMapper.insertSjGfjsFdgz(sjGfjsFdgz);
    }

    /**
     * 修改单位分档规则
     *
     * @param sjGfjsFdgz 单位分档规则
     * @return 结果
     */
    @Override
    public int updateSjGfjsFdgz(SjGfjsFdgz sjGfjsFdgz)
    {
        return sjGfjsFdgzMapper.updateSjGfjsFdgz(sjGfjsFdgz);
    }

    /**
     * 批量删除单位分档规则
     *
     * @param ids 需要删除的单位分档规则主键
     * @return 结果
     */
    @Override
    public int deleteSjGfjsFdgzByIds(Long[] ids)
    {
        return sjGfjsFdgzMapper.deleteSjGfjsFdgzByIds(ids);
    }

    /**
     * 删除单位分档规则信息
     *
     * @param id 单位分档规则主键
     * @return 结果
     */
    @Override
    public int deleteSjGfjsFdgzById(Long id)
    {
        return sjGfjsFdgzMapper.deleteSjGfjsFdgzById(id);
    }
}
