package com.qianhe.service.impl;

import java.util.List;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.domain.JygxBmjj;
import com.qianhe.mapper.JygxBmjjMapper;
import com.qianhe.service.IJygxBmjjService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 经验共享-组织领导Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-30
 */
@Service
public class JygxBmjjServiceImpl implements IJygxBmjjService
{
    @Autowired
    private JygxBmjjMapper jygxBmjjMapper;

    /**
     * 查询经验共享-组织领导
     *
     * @param id 经验共享-组织领导主键
     * @return 经验共享-组织领导
     */
    @Override
    public JygxBmjj selectJygxBmjjById(Long id)
    {
        return jygxBmjjMapper.selectJygxBmjjById(id);
    }

    /**
     * 查询经验共享-组织领导列表
     *
     * @param jygxBmjj 经验共享-组织领导
     * @return 经验共享-组织领导
     */
    @Override
    public List<JygxBmjj> selectJygxBmjjList(JygxBmjj jygxBmjj)
    {
        return jygxBmjjMapper.selectJygxBmjjList(jygxBmjj);
    }

    /**
     * 新增经验共享-组织领导
     *
     * @param jygxBmjj 经验共享-组织领导
     * @return 结果
     */
    @Override
    public int insertJygxBmjj(JygxBmjj jygxBmjj)
    {
        jygxBmjj.setCreateTime(DateUtils.getNowDate());
        return jygxBmjjMapper.insertJygxBmjj(jygxBmjj);
    }

    /**
     * 修改经验共享-组织领导
     *
     * @param jygxBmjj 经验共享-组织领导
     * @return 结果
     */
    @Override
    public int updateJygxBmjj(JygxBmjj jygxBmjj)
    {
        jygxBmjj.setUpdateTime(DateUtils.getNowDate());
        return jygxBmjjMapper.updateJygxBmjj(jygxBmjj);
    }

    /**
     * 批量删除经验共享-组织领导
     *
     * @param ids 需要删除的经验共享-组织领导主键
     * @return 结果
     */
    @Override
    public int deleteJygxBmjjByIds(Long[] ids)
    {
        return jygxBmjjMapper.deleteJygxBmjjByIds(ids);
    }

    /**
     * 删除经验共享-组织领导信息
     *
     * @param id 经验共享-组织领导主键
     * @return 结果
     */
    @Override
    public int deleteJygxBmjjById(Long id)
    {
        return jygxBmjjMapper.deleteJygxBmjjById(id);
    }
}
