package com.qianhe.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.qianhe.domain.SjZdbfFjxbzCb;
import com.qianhe.domain.SjZdbfKhpjbzCb;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.domain.SjZdbfFjxbz;
import com.qianhe.service.ISjZdbfFjxbzService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 指导帮扶-否决项标准Controller
 *
 * @author qianhe
 * @date 2024-07-22
 */
@RestController
@RequestMapping("/system/sjZdbfFjxbz")
public class SjZdbfFjxbzController extends BaseController
{
    @Autowired
    private ISjZdbfFjxbzService sjZdbfFjxbzService;

    /**
     * 查询指导帮扶-否决项标准列表
     */
//    @PreAuthorize("@ss.hasPermi('system:sjZdbfFjxbz:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjZdbfFjxbz sjZdbfFjxbz)
    {
        startPage();
        List<SjZdbfFjxbz> list = sjZdbfFjxbzService.selectSjZdbfFjxbzList(sjZdbfFjxbz);
        return getDataTable(list);
    }
    /**
     * 查询指导帮扶-否决项标准列表
     */
//    @PreAuthorize("@ss.hasPermi('system:sjZdbfFjxbz:cxlist')")
    @GetMapping("/cxlist")
    public TableDataInfo cxlist(SjZdbfFjxbz sjZdbfFjxbz)
    {
//        startPage();
        List<SjZdbfFjxbz> list = sjZdbfFjxbzService.selectSjZdbfFjxbzCxList(sjZdbfFjxbz);
        return getDataTable(list);
    }

    /**
     * 导出指导帮扶-否决项标准列表
     */
//    @PreAuthorize("@ss.hasPermi('system:sjZdbfFjxbz:export')")
    @Log(title = "指导帮扶-否决项标准", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjZdbfFjxbz sjZdbfFjxbz)
    {
        List<SjZdbfFjxbz> list = sjZdbfFjxbzService.selectSjZdbfFjxbzList(sjZdbfFjxbz);
        ExcelUtil<SjZdbfFjxbz> util = new ExcelUtil<SjZdbfFjxbz>(SjZdbfFjxbz.class);
        util.exportExcel(response, list, "指导帮扶-否决项标准数据");
    }

    /**
     * 获取指导帮扶-否决项标准详细信息
     */
//    @PreAuthorize("@ss.hasPermi('system:sjZdbfFjxbz:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjZdbfFjxbzService.selectSjZdbfFjxbzById(id));
    }

    /**
     * 新增指导帮扶-否决项标准
     */
//    @PreAuthorize("@ss.hasPermi('system:sjZdbfFjxbz:add')")
    @Log(title = "指导帮扶-否决项标准", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjZdbfFjxbz sjZdbfFjxbz)
    {
        return toAjax(sjZdbfFjxbzService.insertSjZdbfFjxbz(sjZdbfFjxbz));
    }

    /**
     * 修改指导帮扶-否决项标准
     */
//    @PreAuthorize("@ss.hasPermi('system:sjZdbfFjxbz:edit')")
    @Log(title = "指导帮扶-否决项标准", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjZdbfFjxbz sjZdbfFjxbz)
    {
        return toAjax(sjZdbfFjxbzService.updateSjZdbfFjxbz(sjZdbfFjxbz));
    }

    /**
     * 删除指导帮扶-否决项标准
     */
//    @PreAuthorize("@ss.hasPermi('system:sjZdbfFjxbz:remove')")
    @Log(title = "指导帮扶-否决项标准", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjZdbfFjxbzService.deleteSjZdbfFjxbzByIds(ids));
    }



    /**
     * 查询分类名称集合
     * @param cb
     * @return
     */
    @GetMapping("/getFlmcList")
    public AjaxResult getFlmcList(SjZdbfFjxbzCb cb){
        String nd = cb.getNd();
        cb.setNd(nd.substring(0,4));
        List<String> flmcList = sjZdbfFjxbzService.getFlmcList(cb);
        return success(flmcList);
    }


    /**
     * 查询分类名称集合
     * @param cb
     * @return
     */
    @GetMapping("/getPjbzList")
    public AjaxResult getPjbzList(SjZdbfFjxbzCb cb){
        String nd = cb.getNd();
        cb.setNd(nd.substring(0,4));
        List<SjZdbfFjxbzCb> pjbzList = sjZdbfFjxbzService.getPjbzList(cb);
        return success(pjbzList);
    }
}
