package com.qianhe.controller;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.qianhe.common.core.domain.BaseEntity;
import com.qianhe.common.utils.bean.BeanUtils;
import com.qianhe.domain.Vo.SjfybpVo;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.domain.SjFybp;
import com.qianhe.service.ISjFybpService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 三基-费用报批Controller
 *
 * @author qianhe
 * @date 2024-07-05
 */
@RestController
@RequestMapping("/system/sjFybp")
public class SjFybpController extends BaseController
{
    @Autowired
    private ISjFybpService sjFybpService;

    /**
     * 查询三基-费用报批列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SjFybp sjFybp)
    {
        startPage();
        List<SjFybp> list = sjFybpService.selectSjFybpList(sjFybp);
        return getDataTable(list);
    }

    /**
     * 导出三基-费用报批列表
     */
    @Log(title = "三基-费用报批", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjFybp sjFybp)
    {
        List<SjFybp> list = sjFybpService.selectSjFybpList(sjFybp);
        ExcelUtil<SjFybp> util = new ExcelUtil<SjFybp>(SjFybp.class);
        util.exportExcel(response, list, "三基-费用报批数据");
    }

    /**
     * 获取三基-费用报批详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjFybpService.selectSjFybpById(id));
    }

    /**
     * 新增三基-费用报批
     */
    @Log(title = "三基-费用报批", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjFybp sjFybp)
    {
        return toAjax(sjFybpService.insertSjFybp(sjFybp));
    }

    /**
     * 修改三基-费用报批
     */
    @Log(title = "三基-费用报批", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjFybp sjFybp)
    {
        return toAjax(sjFybpService.updateSjFybp(sjFybp));
    }

    /**
     * 删除三基-费用报批
     */
    @Log(title = "三基-费用报批", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjFybpService.deleteSjFybpByIds(ids));
    }


    /**
     * 提交
     */
    @Log(title = "三基-费用报批", businessType = BusinessType.UPDATE)
    @PostMapping("/tj")
    public AjaxResult tj(@RequestBody SjFybp sjFybp)
    {
        return toAjax(sjFybpService.tj(sjFybp));
    }


//    @Log(title = "三基-费用报批", businessType = BusinessType.UPDATE)

    /**
     * 审批
     * @param sjFybp
     * @return
     */
    @PostMapping("/sp")
    public AjaxResult sp(@RequestBody SjFybp sjFybp)
    {
        return toAjax(sjFybpService.tj(sjFybp));
    }

    /**
     * 查询三基-费用报批列表
     */
    @GetMapping("/splist")
    public TableDataInfo splist(SjFybp sjFybp)
    {
        startPage();
        List<SjFybp> list = sjFybpService.selectSjFybpList(sjFybp);
        return getDataTable(list);
    }

    /**
     * 查询三基-费用报批列表
     */
    @GetMapping("/zglist")
    public TableDataInfo zglist(SjFybp sjFybp)
    {
        startPage();
        List<SjFybp> list = sjFybpService.getFygz(sjFybp);
        return getDataTable(list);
    }


    /**
     * 查询三基-费用报批列表
     */
    @GetMapping("/getFygzById/{id}")
    public AjaxResult getFygz(@PathVariable Long id)
    {

        return AjaxResult.success(sjFybpService.getFygzById(id));
    }

    /**
     * 费用维护
     */
    @Log(title = "三基-费用报批", businessType = BusinessType.UPDATE)
    @PostMapping("fywh")
    public AjaxResult fywh(@RequestBody SjFybp sjFybp)
    {
        return toAjax(sjFybpService.fywh(sjFybp));
    }


    //tjtbByDept

    /**
     * 统计（根据单位）
     * @param sjFybp
     * @return
     */
    @GetMapping("/tjtbByDept")
    public AjaxResult tjtbByDept(SjFybp sjFybp){
        return AjaxResult.success(sjFybpService.tjtbByDept(sjFybp));
    }

    /**
     * 统计（根据费用类型）
     * @param sjFybp
     * @return
     */
    @GetMapping("/tjtbByfylx")
    public AjaxResult tjtbByfylx(SjFybp sjFybp){
        return AjaxResult.success(sjFybpService.tjtbByfylx(sjFybp));
    }

    /**
     * 穿透
     * @param sjFybp
     * @return
     */
    @GetMapping("/tjtbct")
    public TableDataInfo tjtbct(SjFybp sjFybp)
    {
        startPage();
        List<SjFybp> list = sjFybpService.selectSjFybpCtList(sjFybp);
        return getDataTable(list);
    }

    /**
     * 导出三基-费用报批列表
     */
    @Log(title = "三基-费用报批", businessType = BusinessType.EXPORT)
    @PostMapping("/exportTj")
    public void exportTj(HttpServletResponse response, SjFybp sjFybp)
    {
//        List<SjFybp> sjFybps = sjFybpService.tjtbByDept(sjFybp);
//        List<SjfybpVo> voList=new ArrayList<>();
//        sjFybps.forEach(item->{
//            SjfybpVo vo=new SjfybpVo();
//            BeanUtils.copyProperties(item,vo);
//            voList.add(vo);
//        });
//        ExcelUtil<SjfybpVo> util = new ExcelUtil<SjfybpVo>(SjfybpVo.class);
//        util.exportExcel(response, voList, "统计");
    }


    /** 直属单位三基建设费用统计表 */
    @GetMapping("/zsdwNdfytj")
    public List<SjfybpVo> zsdwNdfytj(SjFybp sjFybp)
    {
        List<SjfybpVo> list = sjFybpService.zsdwNdfytj(sjFybp);
        return list;
    }
}
