package com.qianhe.controller;

import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.domain.entity.SysDept;
import com.qianhe.common.core.domain.entity.SysRole;
import com.qianhe.common.core.page.TableDataInfo;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.domain.*;
import com.qianhe.domain.Vo.SjLhscVo;
import com.qianhe.service.*;
import com.qianhe.system.service.ISysDeptService;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 首页
 *
 * @author qianhe
 * @date 2025-08-04
 */
@RestController
@RequestMapping("/system/amain")
public class AmainController extends BaseController
{

    @Autowired
    private IAmainService amainServiceImpl;

    @Autowired
    private ISysDeptService deptService;
    @Autowired
    private ISjLhscService sjLhscService;

    @Autowired
    private ISjFybpZbService sjFybpZbService;

    @Autowired
    private ISjGfjsZsdwkhpjZbService sjGfjsZsdwkhpjZbService;

    @Autowired
    private ISjGfjsYdjcjlService sjGfjsYdjcjlService;

    @Autowired
    private ISjBzxxService sjBzxxService;
    /**
     * 查询班组信息
     */
    @GetMapping("/bzxx")
    public AjaxResult bzxx(Amain vo)
    {
        SjBzxx sjBzxx  = new SjBzxx();
        return AjaxResult.success(sjBzxxService.selectBzxxTj(sjBzxx));
    }

    /**
     * 例会 start------------------------------------------------------------------------------------------------------------------------------------
     */

    @Data
    class CommonLhData {
        private List<SysDept> depts;
        private List<SjLhsc> lhList;
        private String title;
    }
    /**
     * 查询例会查询情况， 看二级例会情况，看三级例会情况
     */
    @GetMapping("/lhQk")
    public AjaxResult lhQk(Amain vo)
    {
        // 调用公共方法获取数据
        CommonLhData commonData = getCommonData_Lh(vo);
        // 处理当前接口的业务逻辑
        Map<String, Map<String, Integer>> lhQkMap = amainServiceImpl.statisticsMeetings(commonData.getDepts(), commonData.getLhList());

        Map  map = new HashMap();
        map.put("title", commonData.getTitle());
        map.put("meetingStats", lhQkMap);
        return AjaxResult.success(map);
    }


    /**
     * 查询例会查询情况， 看二级例会情况，看三级例会情况
     */
    @GetMapping("/lhXq")
    public TableDataInfo lhXq(Amain vo)
    {
      // 调用公共方法获取数据
        CommonLhData commonData = getCommonData_Lh(vo);
        // 处理当前接口的业务逻辑
        List<AmainXq> lhXqList = amainServiceImpl.getDeptQuarterlyStatus(commonData.getDepts(), commonData.getLhList());
        return getDataTable(lhXqList);
    }



    /**
     * 抽取公共逻辑：获取单位列表、例会列表和标题
     */
    private CommonLhData getCommonData_Lh(Amain vo) {
        String nd = vo.getNd();
        String startJd = nd + "-01";
        String endJd = nd + "-12";

        // 获取角色和部门ID（公共参数）
        List<SysRole> rolelist = SecurityUtils.getLoginUser().getUser().getRoles();
        String sylx = getHighestLevel(rolelist); // A/B/C/D角色判断
        Long deptId = SecurityUtils.getDeptId();

        // 初始化返回数据
        CommonLhData data = new CommonLhData();
        List<SysDept> depts = null;
        List<SjLhsc> lhList = null;
        String title = "单位例会提交情况"; // 默认标题

        // 根据角色类型处理（公共逻辑）
        if ("A".equals(sylx)) {
            title = "直属单位例会提交情况";
            // 单位信息
            SysDept dept = new SysDept();
            depts = deptService.selectDeptList_ejdw(dept);
            // 例会信息
            SjLhsc sjLhsc = new SjLhsc();
            sjLhsc.setStartJd(startJd);
            sjLhsc.setEndJd(endJd);
            sjLhsc.setZt("已提交");
            sjLhsc.setDwjb("3");
            lhList = sjLhscService.selectSjLhscList_main(sjLhsc);

        } else if ("B".equals(sylx)) {
            title = "基层单位例会提交情况";
            // 单位信息
            SysDept dept = new SysDept();
            dept.setParentId(deptId);
            depts = deptService.selectDeptList_sjdw(dept);
            // 例会信息
            SjLhsc sjLhsc = new SjLhsc();
            sjLhsc.setStartJd(startJd);
            sjLhsc.setEndJd(endJd);
            sjLhsc.setZt("已提交");
            sjLhsc.setDwjb("4");
            sjLhsc.setParentId(deptId + "");
            lhList = sjLhscService.selectSjLhscList_main(sjLhsc);

        } else if ("C".equals(sylx)) {
            title = "单位例会提交情况";
            // 单位信息
            SysDept dept = new SysDept();
            dept.setDeptId(deptId);
            depts = deptService.selectDeptList_sjdw(dept);
            // 例会信息
            SjLhsc sjLhsc = new SjLhsc();
            sjLhsc.setStartJd(startJd);
            sjLhsc.setEndJd(endJd);
            sjLhsc.setZt("已提交");
            sjLhsc.setDwjb("4");
            sjLhsc.setDeptId(deptId + "");
            lhList = sjLhscService.selectSjLhscList_main(sjLhsc);
        }

        // 封装公共数据并返回
        data.setDepts(depts);
        data.setLhList(lhList);
        data.setTitle(title);
        return data;
    }

    /**
     * 例会 end------------------------------------------------------------------------------------------------------------------------------------
     */


    /**
     * 费用 start------------------------------------------------------------------------------------------------------------------------------------
     */
    @Data
    class CommonFyData {
        private List<SysDept> depts;       // 单位列表
        private List<SjFybpZb> fyList;     // 费用信息列表
        private String title;              // 标题
    }


    /**
     * 查询费用提交情况
     */
    @GetMapping("/fybbQk")
    public AjaxResult fybbQk(Amain vo)
    {
        CommonFyData commonData = getCommonData_fy(vo);
        Map<String, Map<String, Integer>> fyQkMap = amainServiceImpl.countDepartmentExpenses( commonData.getDepts(), commonData.getFyList());
        Map  map = new HashMap();
        map.put("title", commonData.getTitle());
        map.put("expenseStats", fyQkMap);
        return AjaxResult.success(map);
    }


    /**
     * 查询费用提交情况
     */
    @GetMapping("/fybbXq")
    public TableDataInfo fybbXq(Amain vo)
    {
        CommonFyData commonData = getCommonData_fy(vo);
        List<AmainXq> fyXqList = amainServiceImpl.getExpenseStatus(commonData.getDepts(), commonData.getFyList());
        return getDataTable(fyXqList);
    }

    /**
     * 抽取公共逻辑：根据角色和年份获取单位列表、费用列表和标题
     * 专注处理两段代码中完全重复的部分，不干涉各自接口的特有参数
     */
    private CommonFyData getCommonData_fy(Amain vo) {
        // 1. 获取公共参数
        String nd = vo.getNd(); // 年份（从vo中获取，公共参数）
        List<SysRole> rolelist = SecurityUtils.getLoginUser().getUser().getRoles();
        String sylx = getHighestLevel(rolelist); // 角色级别（A/B/C/D）
        Long deptId = SecurityUtils.getDeptId(); // 当前部门ID

        // 2. 初始化公共数据
        CommonFyData data = new CommonFyData();
        List<SysDept> depts = null;
        List<SjFybpZb> fyList = null;
        String title = "费用报批提交情况"; // 默认标题

        // 3. 根据角色类型查询对应的单位和费用列表（完全重复的逻辑）
        if ("A".equals(sylx)) {
            // A角色：查询二级单位及对应费用
            SysDept deptQuery = new SysDept();
            depts = deptService.selectDeptList_ejdw(deptQuery);

            SjFybpZb fyQuery = new SjFybpZb();
            fyQuery.setFyrq(nd);       // 按年份筛选
            fyQuery.setSpcx("1");      // 固定参数
            fyList = sjFybpZbService.selectSjFybpZbList_main(fyQuery);

        } else if ("B".equals(sylx)) {
            // B角色：查询下属基层单位及对应费用
            SysDept deptQuery = new SysDept();
            deptQuery.setParentId(deptId); // 按当前部门ID筛选子单位
            depts = deptService.selectDeptList_sjdw(deptQuery);

            SjFybpZb fyQuery = new SjFybpZb();
            fyQuery.setFyrq(nd);       // 按年份筛选
            fyQuery.setSpcx("1");      // 固定参数
            fyQuery.setDeptId(deptId + ""); // 按当前部门ID筛选费用
            fyList = sjFybpZbService.selectSjFybpZbList_main(fyQuery);
        }

        // 4. 封装并返回公共数据
        data.setDepts(depts);
        data.setFyList(fyList);
        data.setTitle(title);
        return data;
    }

    /**
     * 费用 end------------------------------------------------------------------------------------------------------------------------------------
     */


    /**
     * 直属单位对基层单位的分档评价 start------------------------------------------------------------------------------------------------------------------------------------
     */

    @Data
    class CommonFdpjData {
        private List<SysDept> depts;               // 单位列表
        private List<SjGfjsZsdwkhpjZb> fdpjList;   // 分档评价信息列表
        private String title;                      // 标题
    }

    /**
     * 查询直属单位对基层单位的分档评价情况
     */
    @GetMapping("/zsdwDdpjQk")
    public AjaxResult zsdwDdpjQk(Amain vo)
    {
        CommonFdpjData commonData = getCommonData_Fdpj(vo);
        Map<String, Map<String, Integer>> fdpjQkMap = amainServiceImpl.statisticsGradingEvaluation( commonData.getDepts(), commonData.getFdpjList());
        Map  map = new HashMap();
        map.put("title", commonData.getTitle());
        map.put("expenseStats", fdpjQkMap);
        return AjaxResult.success(map);
    }

    /**
     * 查询直属单位对基层单位的分档评价情况
     */
    @GetMapping("/zsdwDdpjXq")
    public TableDataInfo zsdwDdpjXq(Amain vo)
    {
        CommonFdpjData commonData = getCommonData_Fdpj(vo);
        List<AmainXq> fdpjXqList = amainServiceImpl.getEvaluationStatus( commonData.getDepts(), commonData.getFdpjList());
        return getDataTable(fdpjXqList);
    }


    /**
     * 抽取公共逻辑：根据角色和年份获取单位列表、分档评价列表和标题
     * 专注处理两段代码中完全重复的部分
     */
    private CommonFdpjData getCommonData_Fdpj(Amain vo) {
        // 1. 获取公共参数
        String nd = vo.getNd(); // 年份（公共参数）
        List<SysRole> rolelist = SecurityUtils.getLoginUser().getUser().getRoles();
        String sylx = getHighestLevel(rolelist); // 角色级别（A/B/C/D）
        Long deptId = SecurityUtils.getDeptId(); // 当前部门ID

        // 2. 初始化公共数据
        CommonFdpjData data = new CommonFdpjData();
        List<SysDept> depts = null;
        List<SjGfjsZsdwkhpjZb> fdpjList = null;
        String title = "直属单位对基层单位的分档评价统计"; // 默认标题

        // 3. 根据角色类型查询对应的单位和分档评价列表（完全重复的逻辑）
        if ("A".equals(sylx)) {
            // A角色：查询所有基层单位及分档评价
            SysDept deptQuery = new SysDept();
            depts = deptService.selectDeptList_sjdw(deptQuery);

            SjGfjsZsdwkhpjZb fdpjQuery = new SjGfjsZsdwkhpjZb();
            fdpjQuery.setNd(nd);         // 按年份筛选
            fdpjQuery.setZt("1");        // 固定参数（状态）
            fdpjQuery.setJb("直属单位"); // 固定参数（级别）
            fdpjList = sjGfjsZsdwkhpjZbService.selectSjGfjsZsdwkhpjZbList_main(fdpjQuery);

        } else if ("B".equals(sylx)) {
            // B角色：查询当前部门下属的基层单位及分档评价
            SysDept deptQuery = new SysDept();
            deptQuery.setParentId(deptId); // 按当前部门ID筛选子单位
            depts = deptService.selectDeptList_sjdw(deptQuery);

            SjGfjsZsdwkhpjZb fdpjQuery = new SjGfjsZsdwkhpjZb();
            fdpjQuery.setNd(nd);         // 按年份筛选
            fdpjQuery.setZt("1");        // 固定参数（状态）
            fdpjQuery.setJb("直属单位"); // 固定参数（级别）
            fdpjQuery.setDeptId(deptId); // 按当前部门ID筛选评价
            fdpjList = sjGfjsZsdwkhpjZbService.selectSjGfjsZsdwkhpjZbList_main(fdpjQuery);
        }

        // 4. 封装并返回公共数据
        data.setDepts(depts);
        data.setFdpjList(fdpjList);
        data.setTitle(title);
        return data;
    }


    /**
     * 直属单位对基层单位的分档评价 end------------------------------------------------------------------------------------------------------------------------------------
     */


    /**
     * 查询基层单位月度问题清单 start------------------------------------------------------------------------------------------------------------------------------------
     */

    @Data
    class CommonYdwtData {
        private List<SysDept> depts;               // 单位列表
        private List<SjGfjsYdjcjl> ydwtList;       // 月度问题列表
        private String title;                      // 标题
    }

    /**
     * 查询基层单位月度问题清单提交情况
     */
    @GetMapping("/jcdwYdwtQk")
    public AjaxResult jcdwYdwtQk(Amain vo)
    {
        CommonYdwtData commonData = getCommonData_Ydwt(vo);
        Map<String, Map<String, Integer>> ydwtXkMap = amainServiceImpl.statisticsMonthlyIssues( commonData.getDepts(), commonData.getYdwtList());
        Map  map = new HashMap();
        map.put("title", commonData.getTitle());
        map.put("expenseStats", ydwtXkMap);
        return AjaxResult.success(map);
    }



    /**
     * 查询基层单位月度问题清单提交情况
     */
    @GetMapping("/jcdwYdwtXq")
    public TableDataInfo jcdwYdwtXq(Amain vo)
    {
        CommonYdwtData commonData = getCommonData_Ydwt(vo);
        List<AmainXq> ydwtXqList  = amainServiceImpl.getMonthlyIssueStatus( commonData.getDepts(), commonData.getYdwtList());
        return getDataTable(ydwtXqList);
    }


    private CommonYdwtData getCommonData_Ydwt(Amain vo) {
        // 1. 获取公共参数并处理
        String nd = vo.getNd();
        String startJd = nd + "-01";
        String endJd = nd + "-12";

        List<SysRole> rolelist = SecurityUtils.getLoginUser().getUser().getRoles();
        String sylx = getHighestLevel(rolelist); // 角色级别（A/B/C/D）
        Long deptId = SecurityUtils.getDeptId(); // 当前部门ID

        // 2. 初始化公共数据
        CommonYdwtData data = new CommonYdwtData();
        List<SysDept> depts = null;
        List<SjGfjsYdjcjl> ydwtList = null;
        String title = "基层单位月度问题清单提交情况"; // 默认标题

        // 3. 根据角色类型查询对应的单位和月度问题列表（完全重复的逻辑）
        if ("A".equals(sylx)) {
            // A角色：查询所有基层单位及月度问题
            SysDept deptQuery = new SysDept();
            depts = deptService.selectDeptList_sjdw(deptQuery);

            SjGfjsYdjcjl ydwtQuery = new SjGfjsYdjcjl();
            ydwtQuery.setJcjb("基层单位自查"); // 固定参数
            ydwtQuery.setStartRq(startJd);     // 时间范围起始
            ydwtQuery.setEndRq(endJd);         // 时间范围结束
            ydwtQuery.setZt("1");              // 固定状态参数
            ydwtList = sjGfjsYdjcjlService.selectSjGfjsYdjcjlList_main(ydwtQuery);

        } else if ("B".equals(sylx)) {
            // B角色：查询当前部门下属的基层单位及月度问题
            SysDept deptQuery = new SysDept();
            deptQuery.setParentId(deptId); // 按父部门ID筛选
            depts = deptService.selectDeptList_sjdw(deptQuery);

            SjGfjsYdjcjl ydwtQuery = new SjGfjsYdjcjl();
            ydwtQuery.setDeptId(deptId);       // 按部门ID筛选
            ydwtQuery.setJcjb("基层单位自查"); // 固定参数
            ydwtQuery.setStartRq(startJd);     // 时间范围起始
            ydwtQuery.setEndRq(endJd);         // 时间范围结束
            ydwtQuery.setZt("1");              // 固定状态参数
            ydwtList = sjGfjsYdjcjlService.selectSjGfjsYdjcjlList_main(ydwtQuery);

        } else if ("C".equals(sylx)) {
            // C角色：查询本单位的月度问题
            SysDept deptQuery = new SysDept();
            deptQuery.setDeptId(deptId); // 按本部门ID筛选
            depts = deptService.selectDeptList_sjdw(deptQuery);

            SjGfjsYdjcjl ydwtQuery = new SjGfjsYdjcjl();
            ydwtQuery.setDeptId(deptId);       // 按部门ID筛选
            ydwtQuery.setJcjb("基层单位自查"); // 固定参数
            ydwtQuery.setStartRq(startJd);     // 时间范围起始
            ydwtQuery.setEndRq(endJd);         // 时间范围结束
            ydwtQuery.setZt("1");              // 固定状态参数
            ydwtList = sjGfjsYdjcjlService.selectSjGfjsYdjcjlList_main(ydwtQuery);
        }

        // 4. 封装并返回公共数据
        data.setDepts(depts);
        data.setYdwtList(ydwtList);
        data.setTitle(title);
        return data;
    }

    /**
     * 查询基层单位月度问题清单 end------------------------------------------------------------------------------------------------------------------------------------
     */

    /**
     * 基层单位季度自测提 start------------------------------------------------------------------------------------------------------------------------------------
     */
    @Data
    class CommonJczcData {
        private List<SysDept> depts;               // 单位列表
        private List<SjGfjsZsdwkhpjZb> fdpjList;   // 季度自测列表
        private String title;                      // 标题
    }
    /**
     * 查询基层单位季度自测提交情况
     */
    @GetMapping("/jcdwJdzcQk")
    public AjaxResult jcdwJdzcQk(Amain vo)
    {
        CommonJczcData commonData = getCommonData_Jczc(vo);
        Map<String, Map<String, Integer>> jczcQkMap = amainServiceImpl.statisticsQuarterlyTests( commonData.getDepts(), commonData.getFdpjList());
        Map  map = new HashMap();
        map.put("title", commonData.getTitle());
        map.put("expenseStats", jczcQkMap);
        return AjaxResult.success(map);
    }


    /**
     * 查询基层单位季度自测提交情况
     */
    @GetMapping("/jcdwJdzcXq")
    public TableDataInfo jcdwJdzcXq(Amain vo)
    {
        CommonJczcData commonData = getCommonData_Jczc(vo);
        List<AmainXq> jczcXqList = amainServiceImpl.getQuarterlyTestStatus( commonData.getDepts(), commonData.getFdpjList());
        return getDataTable(jczcXqList);
    }

    private CommonJczcData getCommonData_Jczc(Amain vo) {
        // 1. 获取公共参数
        String nd = vo.getNd();
        List<SysRole> rolelist = SecurityUtils.getLoginUser().getUser().getRoles();
        String sylx = getHighestLevel(rolelist); // 角色级别（A/B/C/D）
        Long deptId = SecurityUtils.getDeptId(); // 当前部门ID

        // 2. 初始化公共数据
        CommonJczcData data = new CommonJczcData();
        List<SysDept> depts = null;
        List<SjGfjsZsdwkhpjZb> fdpjList = null;
        String title = "基层单位季度自测提交情况"; // 默认标题

        // 3. 根据角色类型查询对应的单位和季度自测列表（完全重复的逻辑）
        if ("A".equals(sylx)) {
            // A角色：查询所有基层单位及季度自测数据
            SysDept deptQuery = new SysDept();
            depts = deptService.selectDeptList_sjdw(deptQuery);

            SjGfjsZsdwkhpjZb fdpjQuery = new SjGfjsZsdwkhpjZb();
            fdpjQuery.setNd(nd);         // 按年份筛选
            fdpjQuery.setZt("1");        // 固定状态参数
            fdpjQuery.setJb("基层单位"); // 固定级别参数
            fdpjList = sjGfjsZsdwkhpjZbService.selectSjGfjsZsdwkhpjZbList_main(fdpjQuery);

        } else if ("B".equals(sylx)) {
            // B角色：查询当前部门下属的基层单位及季度自测数据
            SysDept deptQuery = new SysDept();
            deptQuery.setParentId(deptId); // 按父部门ID筛选
            depts = deptService.selectDeptList_sjdw(deptQuery);

            SjGfjsZsdwkhpjZb fdpjQuery = new SjGfjsZsdwkhpjZb();
            fdpjQuery.setNd(nd);         // 按年份筛选
            fdpjQuery.setZt("1");        // 固定状态参数
            fdpjQuery.setJb("基层单位"); // 固定级别参数
            fdpjQuery.setDeptId(deptId); // 按部门ID筛选
            fdpjList = sjGfjsZsdwkhpjZbService.selectSjGfjsZsdwkhpjZbList_main(fdpjQuery);

        } else if ("C".equals(sylx)) {
            // C角色：查询本单位的季度自测数据
            SysDept deptQuery = new SysDept();
            deptQuery.setDeptId(deptId); // 按本部门ID筛选
            depts = deptService.selectDeptList_sjdw(deptQuery);

            SjGfjsZsdwkhpjZb fdpjQuery = new SjGfjsZsdwkhpjZb();
            fdpjQuery.setNd(nd);         // 按年份筛选
            fdpjQuery.setZt("1");        // 固定状态参数
            fdpjQuery.setJb("基层单位"); // 固定级别参数
            fdpjQuery.setDeptId(deptId); // 按部门ID筛选
            fdpjList = sjGfjsZsdwkhpjZbService.selectSjGfjsZsdwkhpjZbList_main(fdpjQuery);
        }

        // 4. 封装并返回公共数据
        data.setDepts(depts);
        data.setFdpjList(fdpjList);
        data.setTitle(title);
        return data;
    }

    /**
     * 基层单位季度自测提 end------------------------------------------------------------------------------------------------------------------------------------
     */






    /* 超级管理员 admin  A  首页看所有
    三基管理员 sjgly  A  首页看所有
    直属单位三基管理员 ejsjgly B   直属单位以下
    基层单位三基管理员 sjsjgly C   基层单位
    帮扶组  D     bfz          空
    机关部门检查 D    jgbmjc  空
    普通角色  common D  空
    练兵指导帮扶 lbzdbf
    */
    public String getHighestLevel(List<SysRole> roleList) {
        // 校验输入
        if (roleList == null || roleList.isEmpty()) {
            return null;
        }
        // 检查是否有A级角色
        boolean hasLevelA = roleList.stream()
                .anyMatch(role -> "admin".equals(role.getRoleKey()));
        if (hasLevelA) {
            return "A";
        }
        hasLevelA = roleList.stream()
                .anyMatch(role -> "sjgly".equals(role.getRoleKey()));
        if (hasLevelA) {
            return "A";
        }

        // 检查是否有B级角色
        boolean hasLevelB = roleList.stream()
                .anyMatch(role -> "ejsjgly".equals(role.getRoleKey()));
        if (hasLevelB) {
            return "B";
        }

        // 检查是否有C级角色
        boolean hasLevelC = roleList.stream()
                .anyMatch(role -> "sjsjgly".equals(role.getRoleKey()));
        if (hasLevelC) {
            return "C";
        }

        // 没有任何级别的角色
        return "D";
    }









}
