package com.qianhe.mapper;

import java.util.List;
import java.util.Map;

import com.qianhe.domain.GgFjb;
import org.apache.ibatis.annotations.Param;

/**
 * 公共附件Mapper接口
 * 
 * @author qianhe
 * @date 2025-08-04
 */
public interface GgFjbMapper 
{
    /**
     * 查询公共附件
     * 
     * @param ID 公共附件主键
     * @return 公共附件
     */
    public GgFjb selectGgFjbByID(Long ID);

    /**
     * 查询公共附件列表
     * 
     * @param ggFjb 公共附件
     * @return 公共附件集合
     */
    public List<GgFjb> selectGgFjbList(GgFjb ggFjb);

    /**
     * 新增公共附件
     * 
     * @param ggFjb 公共附件
     * @return 结果
     */
    public int insertGgFjb(GgFjb ggFjb);

    /**
     * 修改公共附件
     * 
     * @param ggFjb 公共附件
     * @return 结果
     */
    public int updateGgFjb(GgFjb ggFjb);

    /**
     * 删除公共附件
     * 
     * @param ID 公共附件主键
     * @return 结果
     */
    public int deleteGgFjbByID(Long ID);

    /**
     * 批量删除公共附件
     * 
     * @param IDs 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteGgFjbByIDs(Long[] IDs);




    public int deleteFjByYwid(GgFjb ggFjb);
    public int insertFj(GgFjb zbZbjcxxfjb);
    List<GgFjb> selectFj(@Param("id") Long id, @Param("mkmc") String mkmc);
    List<GgFjb> selectFjByMk(@Param("mkmc") String mkmc);

}
