package com.qianhe.mapper;

import java.util.List;
import com.qianhe.domain.SjFybp;
import com.qianhe.domain.SjFybpWh;
import com.qianhe.domain.Vo.SjfybpVo;

/**
 * 三基-费用报批Mapper接口
 * 
 * @author qianhe
 * @date 2024-07-05
 */
public interface SjFybpMapper 
{
    /**
     * 查询三基-费用报批
     * 
     * @param id 三基-费用报批主键
     * @return 三基-费用报批
     */
    public SjFybp selectSjFybpById(Long id);

    /**
     * 查询三基-费用报批列表
     * 
     * @param sjFybp 三基-费用报批
     * @return 三基-费用报批集合
     */
    public List<SjFybp> selectSjFybpList(SjFybp sjFybp);

    /**
     * 新增三基-费用报批
     * 
     * @param sjFybp 三基-费用报批
     * @return 结果
     */
    public int insertSjFybp(SjFybp sjFybp);

    /**
     * 修改三基-费用报批
     * 
     * @param sjFybp 三基-费用报批
     * @return 结果
     */
    public int updateSjFybp(SjFybp sjFybp);

    /**
     * 删除三基-费用报批
     * 
     * @param id 三基-费用报批主键
     * @return 结果
     */
    public int deleteSjFybpById(Long id);

    /**
     * 批量删除三基-费用报批
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSjFybpByIds(Long[] ids);

    /**
     * 批量删除三基-费用维护
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSjFybpWhByFybpIds(Long[] ids);
    
    /**
     * 批量新增三基-费用维护
     * 
     * @param sjFybpWhList 三基-费用维护列表
     * @return 结果
     */
    public int batchSjFybpWh(List<SjFybpWh> sjFybpWhList);
    

    /**
     * 通过三基-费用报批主键删除三基-费用维护信息
     * 
     * @param id 三基-费用报批ID
     * @return 结果
     */
    public int deleteSjFybpWhByFybpId(Long id);

    List<SjfybpVo> tjtbByDept(SjFybp sjFybp);

    List<SjfybpVo> tjtbByfylx(SjFybp sjFybp);

    List<SjFybp> selectSjFybpByZbId(Long zbid);


    List<SjFybp> getFygz(SjFybp sjFybp);


    SjFybp getFygzById(Long id);

    List<SjFybp> selectSjFybpCtList(SjFybp sjFybp);

}
