package com.qianhe.domain;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;

/**
 * 班组信息对象 sj_bzxx
 *
 * @author qianhe
 * @date 2025-08-04
 */
@Data
public class SjBzxx extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 单位id */
    private Long deptId;

    @Excel(name = "单位名称")
    private String deptName;

    /** 班组名称 */
    @Excel(name = "班组名称")
    private String bzmc;

    /** 班组类型 */
    @Excel(name = "班组类型")
    private String bzlx;

    /** 人数 */
    @Excel(name = "人数")
    private String rs;

    /** 状态 0 未提交 1 已提交 */
    @Excel(name = "状态 0 未提交 1 已提交")
    private String zt;



    //查询出的结果

    private String bzzs;//班组总数
    private String zrs;//总人数

    //传入参数
    private String ids;//批量ids 例如6,7,8 只有一个传入6


}
