package com.qianhe.service.impl;

import java.util.Arrays;
import java.util.List;

import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.domain.*;
import com.qianhe.domain.Vo.SjLhscVo;
import com.qianhe.mapper.WdWdxxMapper;
import com.qianhe.service.IGgFjbService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;

import com.qianhe.common.utils.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import com.qianhe.mapper.SjLhscMapper;
import com.qianhe.service.ISjLhscService;

/**
 * 三基-例会上传Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-08
 */
@Service
public class SjLhscServiceImpl implements ISjLhscService
{
    @Autowired
    private SjLhscMapper sjLhscMapper;

    @Autowired
    private WdWdxxMapper wdWdxxMapper;

    @Autowired
    private IGgFjbService fjbService;

    /**
     * 查询三基-例会上传
     *
     * @param id 三基-例会上传主键
     * @return 三基-例会上传
     */
    @Override

    public SjLhsc selectSjLhscById(Long id)
    {
        SjLhsc sjLhsc = sjLhscMapper.selectSjLhscById(id);
        List<SjLhscWt> sjLhscWts = sjLhscMapper.selectSjLhscWtListById(id);
        sjLhsc.setSjLhscWtList(sjLhscWts);
        //查询文档
        WdWdxx wdWdxx=new WdWdxx();
        wdWdxx.setGlId(sjLhsc.getId().toString());
        wdWdxx.setMkmc("例会上传");
        wdWdxx.setFjlx("例会上传");
        List<WdWdxx> wdWdxxes = wdWdxxMapper.selectWdWdxxList(wdWdxx);
        sjLhsc.setFileList(wdWdxxes);



        //查询附件
        List<GgFjb> fjlist = fjbService.selectFj(id,"例会上传");
        Map<String, List<GgFjb>> map = fjlist.stream().collect(Collectors.groupingBy(GgFjb::getFJLX));
        if(map.get("例会上传")!=null){
            List<GgFjb> fileData = map.get("例会上传").stream().collect(Collectors.toList());
            sjLhsc.setFileList1(fileData);
        }


        return sjLhsc;
    }

    /**
     * 查询三基-例会上传列表
     *
     * @param sjLhsc 三基-例会上传
     * @return 三基-例会上传
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<SjLhsc> selectSjLhscList(SjLhsc sjLhsc)
    {
        List<SjLhsc> rl = sjLhscMapper.selectSjLhscList(sjLhsc);

        //查询附件
        List<GgFjb> fjlistAll = fjbService.selectFjByMk("例会上传");
        for(SjLhsc rt:rl){
            Long id = rt.getId();
            String ids = String.valueOf(id);

            List<GgFjb> fjlist = fjlistAll.stream().filter(e->e.getYWID().equals(ids)).collect(Collectors.toList());

            Map<String, List<GgFjb>> map = fjlist.stream().collect(Collectors.groupingBy(GgFjb::getFJLX));

            if(map.get("例会上传")!=null){
                List<GgFjb> fileData = new ArrayList<>(map.get("例会上传"));
                rt.setFileList1(fileData);
            }
        }

        return rl;
    }

    @Override
    public List<SjLhsc> selectSjLhscList_main(SjLhsc sjLhsc)
    {
        List<SjLhsc> rl = sjLhscMapper.selectSjLhscList_main(sjLhsc);

        //查询附件
        List<GgFjb> fjlistAll = fjbService.selectFjByMk("例会上传");
        for(SjLhsc rt:rl){
            Long id = rt.getId();
            String ids = String.valueOf(id);

            List<GgFjb> fjlist = fjlistAll.stream().filter(e->e.getYWID().equals(ids)).collect(Collectors.toList());

            Map<String, List<GgFjb>> map = fjlist.stream().collect(Collectors.groupingBy(GgFjb::getFJLX));

            if(map.get("例会上传")!=null){
                List<GgFjb> fileData = new ArrayList<>(map.get("例会上传"));
                rt.setFileList1(fileData);
            }
        }

        return rl;
    }

    /**
     * 新增三基-例会上传
     *
     * @param sjLhsc 三基-例会上传
     * @return 结果
     */
    @Transactional
    @Override
    public int insertSjLhsc(SjLhsc sjLhsc)
    {
        sjLhsc.setCreateTime(DateUtils.getNowDate());
        sjLhsc.setCreateBy(SecurityUtils.getUsername());
        int rows = sjLhscMapper.insertSjLhsc(sjLhsc);
        if(StringUtils.isNotEmpty(sjLhsc.getJjwt())){
            String[] split = sjLhsc.getJjwt().split("/(?<=\\d)(?=[.：,、\\s])/");
            sjLhsc.setWtList(Arrays.asList(split));
        }
        insertSjLhscWtString(sjLhsc);
//        insertSjLhscWt(sjLhsc);
        //保存文件
        if(StringUtils.isNotEmpty(sjLhsc.getFileList())){
            if(sjLhsc.getFileList().size()>0){
                sjLhsc.getFileList().forEach(file->{
                    file.setGlId(sjLhsc.getId().toString());
                    file.setMkmc("例会上传");
                    file.setFjlx("例会上传");
                    file.setLrr(SecurityUtils.getUsername());
                    wdWdxxMapper.insertWdWdxx(file);
                });
            }
        }
        return rows;
    }

    /**
     * 修改三基-例会上传
     *
     * @param sjLhsc 三基-例会上传
     * @return 结果
     */
    @Transactional
    @Override
    public int updateSjLhsc(SjLhsc sjLhsc)
    {

        //先删除文件
        wdWdxxMapper.deleteWdWdxxByGlIdAndMkmc(sjLhsc.getId()+"","例会上传");
        //保存文件
        if(StringUtils.isNotEmpty(sjLhsc.getFileList())){
            if(sjLhsc.getFileList().size()>0){
                sjLhsc.getFileList().forEach(file->{
                    file.setGlId(sjLhsc.getId().toString());
                    file.setMkmc("例会上传");
                    file.setFjlx("例会上传");
                    file.setLrr(SecurityUtils.getUsername());
                    wdWdxxMapper.insertWdWdxx(file);
                });
            }
        }

        sjLhsc.setUpdateTime(DateUtils.getNowDate());
        sjLhsc.setUpdateBy(SecurityUtils.getUsername());
        sjLhscMapper.deleteSjLhscWtByLhscId(sjLhsc.getId());
//        insertSjLhscWt(sjLhsc);
        if(StringUtils.isNotEmpty(sjLhsc.getJjwt())){
            String[] split = sjLhsc.getJjwt().split("/(?<=\\d)(?=[.：,、\\s])/");
            sjLhsc.setWtList(Arrays.asList(split));
        }
        insertSjLhscWtString(sjLhsc);


        return sjLhscMapper.updateSjLhsc(sjLhsc);
    }

    /**
     * 批量删除三基-例会上传
     *
     * @param ids 需要删除的三基-例会上传主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSjLhscByIds(Long[] ids)
    {
        sjLhscMapper.deleteSjLhscWtByLhscIds(ids);
        return sjLhscMapper.deleteSjLhscByIds(ids);
    }

    /**
     * 删除三基-例会上传信息
     *
     * @param id 三基-例会上传主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSjLhscById(Long id)
    {
        sjLhscMapper.deleteSjLhscWtByLhscId(id);
        return sjLhscMapper.deleteSjLhscById(id);
    }

    @Override
    public int tj(SjLhsc sjLhsc) {
        return sjLhscMapper.updateSjLhsc(sjLhsc);
    }

    @Override
    @DataScope(deptAlias = "d")
    public List<SjLhscVo> tjBysfsc(SjLhscVo vo) {

        return sjLhscMapper.tjBysfsc(vo);
    }

    @Override
    @DataScope(deptAlias = "d")
    public List<SjLhscVo> tjByEjJjwtSl(SjLhscVo vo) {
        return sjLhscMapper.tjByEjJjwtSl(vo);
    }

    @Override
    public List<SjLhsc> selectSjLhscLhgxList(SjLhsc sjLhsc) {
        List<SjLhsc> rl = sjLhscMapper.selectSjLhscLhgxList(sjLhsc);

        //查询附件
        List<GgFjb> fjlistAll = fjbService.selectFjByMk("例会上传");
        for(SjLhsc rt:rl){
            Long id = rt.getId();
            String ids = String.valueOf(id);

            List<GgFjb> fjlist = fjlistAll.stream().filter(e->e.getYWID().equals(ids)).collect(Collectors.toList());

            Map<String, List<GgFjb>> map = fjlist.stream().collect(Collectors.groupingBy(GgFjb::getFJLX));

            if(map.get("例会上传")!=null){
                List<GgFjb> fileData = new ArrayList<>(map.get("例会上传"));
                rt.setFileList1(fileData);
            }
        }


        return rl;
    }

    /**
     * 新增三基-例会上传-存在问题信息
     *
     * @param sjLhsc 三基-例会上传对象
     */
    public void insertSjLhscWt(SjLhsc sjLhsc)
    {
        List<SjLhscWt> sjLhscWtList = sjLhsc.getSjLhscWtList();
        Long id = sjLhsc.getId();
        if (StringUtils.isNotNull(sjLhscWtList))
        {
            List<SjLhscWt> list = new ArrayList<SjLhscWt>();
            for (SjLhscWt sjLhscWt : sjLhscWtList)
            {
                sjLhscWt.setLhscId(id);
                list.add(sjLhscWt);
            }
            if (list.size() > 0)
            {
                sjLhscMapper.batchSjLhscWt(list);
            }
        }
    }

    public void insertSjLhscWtString(SjLhsc sjLhsc)
    {
        List<String> sjLhscWtList = sjLhsc.getWtList();
        Long id = sjLhsc.getId();
        if (StringUtils.isNotNull(sjLhscWtList))
        {
            List<SjLhscWt> list = new ArrayList<SjLhscWt>();
            for (String wt : sjLhscWtList)
            {
                SjLhscWt sjLhscWt=new SjLhscWt();
                sjLhscWt.setLhscId(id);
                sjLhscWt.setWt(wt);
                list.add(sjLhscWt);
            }
            if (list.size() > 0)
            {
                sjLhscMapper.batchSjLhscWt(list);
            }
        }
    }
}
