package com.qianhe.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.domain.SjBzxx;
import com.qianhe.service.ISjBzxxService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 班组信息Controller
 *
 * @author qianhe
 * @date 2025-08-04
 */
@RestController
@RequestMapping("/system/sjBzxx")
public class SjBzxxController extends BaseController
{
    @Autowired
    private ISjBzxxService sjBzxxService;

    /**
     * 查询班组信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SjBzxx sjBzxx)
    {
        startPage();
        List<SjBzxx> list = sjBzxxService.selectSjBzxxList(sjBzxx);
        return getDataTable(list);
    }

    /**
     * 导出班组信息列表
     */
    @Log(title = "班组信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjBzxx sjBzxx)
    {
        List<SjBzxx> list = sjBzxxService.selectSjBzxxList(sjBzxx);
        ExcelUtil<SjBzxx> util = new ExcelUtil<SjBzxx>(SjBzxx.class);
        util.exportExcel(response, list, "班组信息数据");
    }

    /**
     * 获取班组信息详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjBzxxService.selectSjBzxxById(id));
    }

    /**
     * 新增班组信息
     */
    @Log(title = "班组信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjBzxx sjBzxx)
    {
        return toAjax(sjBzxxService.insertSjBzxx(sjBzxx));
    }

    /**
     * 修改班组信息
     */
    @Log(title = "班组信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjBzxx sjBzxx)
    {
        return toAjax(sjBzxxService.updateSjBzxx(sjBzxx));
    }

    /**
     * 删除班组信息
     */
    @Log(title = "班组信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjBzxxService.deleteSjBzxxByIds(ids));
    }





    /**
     * 获取班组 统计信息
     */
    @PostMapping(value = "/getBzTj")
    public AjaxResult getBzTj(@RequestBody SjBzxx sjBzxx)
    {
        return success(sjBzxxService.selectBzxxTj(sjBzxx));
    }
    /**
     * 批量提交
     */
    @PostMapping(value = "/pltj")
    public AjaxResult pltj(@RequestBody SjBzxx sjBzxx)
    {
        sjBzxx.setZt("1");
        return success(sjBzxxService.pltj(sjBzxx));
    }



    /** 查询统计 单位班组人数统计信息 */
    @GetMapping("/dwbzrstjList")
    public List<SjBzxx> dwbzrstjList(SjBzxx sjBzxx)
    {
        List<SjBzxx> list = sjBzxxService.dwbzrstjList(sjBzxx);
        return list;
    }

}
