package com.qianhe.service.impl;

import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.domain.SjZdbfZsdwkhpjZb;
import com.qianhe.mapper.SjZdbfJcdwkhpjZbMapper;
import com.qianhe.mapper.SjZdbfndkhpjZbMapper;
import com.qianhe.service.ISjZdbfndkhpjZbService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 指导帮扶-年度考核评价主Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-24
 */
@Service
public class SjZdbfndkhpjZbServiceImpl implements ISjZdbfndkhpjZbService
{
    @Autowired
    private SjZdbfndkhpjZbMapper sjZdbfZsdwkhpjZbMapper;

    /**
     * 查询指导帮扶-年度考核评价主
     *
     * @param id 指导帮扶-年度考核评价主主键
     * @return 指导帮扶-年度考核评价主
     */
    @Override
    public SjZdbfZsdwkhpjZb selectSjZdbfZsdwkhpjZbById(Long id)
    {
        return sjZdbfZsdwkhpjZbMapper.selectSjZdbfZsdwkhpjZbById(id);
    }

    /**
     * 查询指导帮扶-年度考核评价主列表
     *
     * @param sjZdbfZsdwkhpjZb 指导帮扶-年度考核评价主
     * @return 指导帮扶-年度考核评价主
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<SjZdbfZsdwkhpjZb> selectSjZdbfZsdwkhpjZbList(SjZdbfZsdwkhpjZb sjZdbfZsdwkhpjZb)
    {
        return sjZdbfZsdwkhpjZbMapper.selectSjZdbfZsdwkhpjZbList(sjZdbfZsdwkhpjZb);
    }

    /**
     * 新增指导帮扶-年度考核评价主
     *
     * @param sjZdbfZsdwkhpjZb 指导帮扶-年度考核评价主
     * @return 结果
     */
    @Override
    public int insertSjZdbfZsdwkhpjZb(SjZdbfZsdwkhpjZb sjZdbfZsdwkhpjZb)
    {
        sjZdbfZsdwkhpjZb.setCreateTime(DateUtils.getNowDate());
        return sjZdbfZsdwkhpjZbMapper.insertSjZdbfZsdwkhpjZb(sjZdbfZsdwkhpjZb);
    }

    /**
     * 修改指导帮扶-年度考核评价主
     *
     * @param sjZdbfZsdwkhpjZb 指导帮扶-年度考核评价主
     * @return 结果
     */
    @Override
    public int updateSjZdbfZsdwkhpjZb(SjZdbfZsdwkhpjZb sjZdbfZsdwkhpjZb)
    {
        sjZdbfZsdwkhpjZb.setUpdateTime(DateUtils.getNowDate());
        return sjZdbfZsdwkhpjZbMapper.updateSjZdbfZsdwkhpjZb(sjZdbfZsdwkhpjZb);
    }

    /**
     * 批量删除指导帮扶-年度考核评价主
     *
     * @param ids 需要删除的指导帮扶-年度考核评价主主键
     * @return 结果
     */
    @Override
    public int deleteSjZdbfZsdwkhpjZbByIds(Long[] ids)
    {
        return sjZdbfZsdwkhpjZbMapper.deleteSjZdbfZsdwkhpjZbByIds(ids);
    }

    /**
     * 删除指导帮扶-年度考核评价主信息
     *
     * @param id 指导帮扶-年度考核评价主主键
     * @return 结果
     */
    @Override
    public int deleteSjZdbfZsdwkhpjZbById(Long id)
    {
        return sjZdbfZsdwkhpjZbMapper.deleteSjZdbfZsdwkhpjZbById(id);
    }

    @Override
    public SjZdbfZsdwkhpjZb selectSjZdbfZsdwkhpjZb(SjZdbfZsdwkhpjZb sjZdbfZsdwkhpjZb) {
        return sjZdbfZsdwkhpjZbMapper.selectSjZdbfZsdwkhpjZb(sjZdbfZsdwkhpjZb);
    }
}
