package com.qianhe.service.impl;

import java.util.Arrays;
import java.util.List;

import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.domain.Vo.SjLhscVo;
import com.qianhe.domain.WdWdxx;
import com.qianhe.mapper.WdWdxxMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import com.qianhe.common.utils.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import com.qianhe.domain.SjLhscWt;
import com.qianhe.mapper.SjLhscMapper;
import com.qianhe.domain.SjLhsc;
import com.qianhe.service.ISjLhscService;

/**
 * 三基-例会上传Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-08
 */
@Service
public class SjLhscServiceImpl implements ISjLhscService
{
    @Autowired
    private SjLhscMapper sjLhscMapper;

    @Autowired
    private WdWdxxMapper wdWdxxMapper;

    /**
     * 查询三基-例会上传
     *
     * @param id 三基-例会上传主键
     * @return 三基-例会上传
     */
    @Override

    public SjLhsc selectSjLhscById(Long id)
    {
        SjLhsc sjLhsc = sjLhscMapper.selectSjLhscById(id);
        List<SjLhscWt> sjLhscWts = sjLhscMapper.selectSjLhscWtListById(id);
        sjLhsc.setSjLhscWtList(sjLhscWts);
        //查询文档
        WdWdxx wdWdxx=new WdWdxx();
        wdWdxx.setGlId(sjLhsc.getId().toString());
        wdWdxx.setMkmc("例会上传");
        wdWdxx.setFjlx("例会上传");
        List<WdWdxx> wdWdxxes = wdWdxxMapper.selectWdWdxxList(wdWdxx);
        sjLhsc.setFileList(wdWdxxes);
        return sjLhsc;
    }

    /**
     * 查询三基-例会上传列表
     *
     * @param sjLhsc 三基-例会上传
     * @return 三基-例会上传
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<SjLhsc> selectSjLhscList(SjLhsc sjLhsc)
    {
        return sjLhscMapper.selectSjLhscList(sjLhsc);
    }

    /**
     * 新增三基-例会上传
     *
     * @param sjLhsc 三基-例会上传
     * @return 结果
     */
    @Transactional
    @Override
    public int insertSjLhsc(SjLhsc sjLhsc)
    {
        sjLhsc.setCreateTime(DateUtils.getNowDate());
        sjLhsc.setCreateBy(SecurityUtils.getUsername());
        int rows = sjLhscMapper.insertSjLhsc(sjLhsc);
        if(StringUtils.isNotEmpty(sjLhsc.getJjwt())){
            String[] split = sjLhsc.getJjwt().split("/(?<=\\d)(?=[.：,、\\s])/");
            sjLhsc.setWtList(Arrays.asList(split));
        }
        insertSjLhscWtString(sjLhsc);
//        insertSjLhscWt(sjLhsc);
        //保存文件
        if(StringUtils.isNotEmpty(sjLhsc.getFileList())){
            if(sjLhsc.getFileList().size()>0){
                sjLhsc.getFileList().forEach(file->{
                    file.setGlId(sjLhsc.getId().toString());
                    file.setMkmc("例会上传");
                    file.setFjlx("例会上传");
                    file.setLrr(SecurityUtils.getUsername());
                    wdWdxxMapper.insertWdWdxx(file);
                });
            }
        }
        return rows;
    }

    /**
     * 修改三基-例会上传
     *
     * @param sjLhsc 三基-例会上传
     * @return 结果
     */
    @Transactional
    @Override
    public int updateSjLhsc(SjLhsc sjLhsc)
    {

        //先删除文件
        wdWdxxMapper.deleteWdWdxxByGlIdAndMkmc(sjLhsc.getId()+"","例会上传");
        //保存文件
        if(StringUtils.isNotEmpty(sjLhsc.getFileList())){
            if(sjLhsc.getFileList().size()>0){
                sjLhsc.getFileList().forEach(file->{
                    file.setGlId(sjLhsc.getId().toString());
                    file.setMkmc("例会上传");
                    file.setFjlx("例会上传");
                    file.setLrr(SecurityUtils.getUsername());
                    wdWdxxMapper.insertWdWdxx(file);
                });
            }
        }

        sjLhsc.setUpdateTime(DateUtils.getNowDate());
        sjLhsc.setUpdateBy(SecurityUtils.getUsername());
        sjLhscMapper.deleteSjLhscWtByLhscId(sjLhsc.getId());
//        insertSjLhscWt(sjLhsc);
        if(StringUtils.isNotEmpty(sjLhsc.getJjwt())){
            String[] split = sjLhsc.getJjwt().split("/(?<=\\d)(?=[.：,、\\s])/");
            sjLhsc.setWtList(Arrays.asList(split));
        }
        insertSjLhscWtString(sjLhsc);


        return sjLhscMapper.updateSjLhsc(sjLhsc);
    }

    /**
     * 批量删除三基-例会上传
     *
     * @param ids 需要删除的三基-例会上传主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSjLhscByIds(Long[] ids)
    {
        sjLhscMapper.deleteSjLhscWtByLhscIds(ids);
        return sjLhscMapper.deleteSjLhscByIds(ids);
    }

    /**
     * 删除三基-例会上传信息
     *
     * @param id 三基-例会上传主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSjLhscById(Long id)
    {
        sjLhscMapper.deleteSjLhscWtByLhscId(id);
        return sjLhscMapper.deleteSjLhscById(id);
    }

    @Override
    public int tj(SjLhsc sjLhsc) {
        return sjLhscMapper.updateSjLhsc(sjLhsc);
    }

    @Override
    @DataScope(deptAlias = "d")
    public List<SjLhscVo> tjBysfsc(SjLhscVo vo) {

        return sjLhscMapper.tjBysfsc(vo);
    }

    @Override
    @DataScope(deptAlias = "d")
    public List<SjLhscVo> tjByEjJjwtSl(SjLhscVo vo) {
        return sjLhscMapper.tjByEjJjwtSl(vo);
    }

    @Override
    public List<SjLhsc> selectSjLhscLhgxList(SjLhsc sjLhsc) {
        return sjLhscMapper.selectSjLhscLhgxList(sjLhsc);
    }

    /**
     * 新增三基-例会上传-存在问题信息
     *
     * @param sjLhsc 三基-例会上传对象
     */
    public void insertSjLhscWt(SjLhsc sjLhsc)
    {
        List<SjLhscWt> sjLhscWtList = sjLhsc.getSjLhscWtList();
        Long id = sjLhsc.getId();
        if (StringUtils.isNotNull(sjLhscWtList))
        {
            List<SjLhscWt> list = new ArrayList<SjLhscWt>();
            for (SjLhscWt sjLhscWt : sjLhscWtList)
            {
                sjLhscWt.setLhscId(id);
                list.add(sjLhscWt);
            }
            if (list.size() > 0)
            {
                sjLhscMapper.batchSjLhscWt(list);
            }
        }
    }

    public void insertSjLhscWtString(SjLhsc sjLhsc)
    {
        List<String> sjLhscWtList = sjLhsc.getWtList();
        Long id = sjLhsc.getId();
        if (StringUtils.isNotNull(sjLhscWtList))
        {
            List<SjLhscWt> list = new ArrayList<SjLhscWt>();
            for (String wt : sjLhscWtList)
            {
                SjLhscWt sjLhscWt=new SjLhscWt();
                sjLhscWt.setLhscId(id);
                sjLhscWt.setWt(wt);
                list.add(sjLhscWt);
            }
            if (list.size() > 0)
            {
                sjLhscMapper.batchSjLhscWt(list);
            }
        }
    }
}
