package com.qianhe.service.impl;

import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.core.domain.entity.SysDept;
import com.qianhe.common.core.domain.entity.SysDictData;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.domain.SjGfjsZsdwkhpj;
import com.qianhe.domain.SjGfjsZsdwkhpjZb;
import com.qianhe.mapper.SjGfjsZsdwkhpjMapper;
import com.qianhe.mapper.SjGfjsZsdwkhpjZbMapper;
import com.qianhe.service.ISjGfjsZsdwkhpjService;
import com.qianhe.system.mapper.SysDeptMapper;
import com.qianhe.system.mapper.SysDictDataMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 规范建设-直属单位考核评价Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-24
 */
@Service
public class SjGfjsZsdwkhpjServiceImpl implements ISjGfjsZsdwkhpjService
{
    @Autowired
    private SjGfjsZsdwkhpjMapper sjGfjsZsdwkhpjMapper;
    @Autowired
    private SjGfjsZsdwkhpjZbMapper sjGfjsZsdwkhpjZbMapper;
    @Autowired
    private SysDictDataMapper sysDictDataMapper;
    @Autowired
    private SysDeptMapper sysDeptMapper;

    /**
     * 查询规范建设-直属单位考核评价
     *
     * @param id 规范建设-直属单位考核评价主键
     * @return 规范建设-直属单位考核评价
     */
    @Override
    public SjGfjsZsdwkhpj selectSjGfjsZsdwkhpjById(Long id)
    {
        return sjGfjsZsdwkhpjMapper.selectSjGfjsZsdwkhpjById(id);
    }

    /**
     * 查询规范建设-直属单位考核评价列表
     *
     * @param sjGfjsZsdwkhpj 规范建设-直属单位考核评价
     * @return 规范建设-直属单位考核评价
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<SjGfjsZsdwkhpj> selectSjGfjsZsdwkhpjList(SjGfjsZsdwkhpj sjGfjsZsdwkhpj)
    {
        return sjGfjsZsdwkhpjMapper.selectSjGfjsZsdwkhpjList(sjGfjsZsdwkhpj);
    }

    /**
     * 新增规范建设-直属单位考核评价
     *
     * @param sjGfjsZsdwkhpj 规范建设-直属单位考核评价
     * @return 结果
     */
    @Override
    public int insertSjGfjsZsdwkhpj(SjGfjsZsdwkhpj sjGfjsZsdwkhpj)
    {
        sjGfjsZsdwkhpj.setCreateTime(DateUtils.getNowDate());
        return sjGfjsZsdwkhpjMapper.insertSjGfjsZsdwkhpj(sjGfjsZsdwkhpj);
    }

    /**
     * 修改规范建设-直属单位考核评价
     *
     * @param sjGfjsZsdwkhpj 规范建设-直属单位考核评价
     * @return 结果
     */
    @Override
    public int updateSjGfjsZsdwkhpj(SjGfjsZsdwkhpj sjGfjsZsdwkhpj)
    {
        sjGfjsZsdwkhpj.setUpdateTime(DateUtils.getNowDate());
        sjGfjsZsdwkhpj.setUpdateBy(SecurityUtils.getUsername());
        //计算分数
        return sjGfjsZsdwkhpjMapper.updateSjGfjsZsdwkhpj(sjGfjsZsdwkhpj);
    }

    /**
     * 批量删除规范建设-直属单位考核评价
     *
     * @param ids 需要删除的规范建设-直属单位考核评价主键
     * @return 结果
     */
    @Override
    public int deleteSjGfjsZsdwkhpjByIds(Long[] ids)
    {
        return sjGfjsZsdwkhpjMapper.deleteSjGfjsZsdwkhpjByIds(ids);
    }

    /**
     * 删除规范建设-直属单位考核评价信息
     *
     * @param id 规范建设-直属单位考核评价主键
     * @return 结果
     */
    @Override
    public int deleteSjGfjsZsdwkhpjById(Long id)
    {
        return sjGfjsZsdwkhpjMapper.deleteSjGfjsZsdwkhpjById(id);
    }

    @Override
    public int batchSave(List<SjGfjsZsdwkhpj> addList) {
        return sjGfjsZsdwkhpjMapper.batchSave(addList);
    }

    @Override
    public int pledit(List<SjGfjsZsdwkhpj> list) {
        //计算分数
        SjGfjsZsdwkhpj sjGfjsZsdwkhpj = list.get(0);
        SjGfjsZsdwkhpjZb sjGfjsZsdwkhpjZb = sjGfjsZsdwkhpjZbMapper.selectSjGfjsZsdwkhpjZbById(sjGfjsZsdwkhpj.getZbId());
        SysDept dept = sysDeptMapper.selectDeptById(sjGfjsZsdwkhpjZb.getDeptId());
        Map<String,List<SjGfjsZsdwkhpj>> stringListMap = list.stream().collect(Collectors.groupingBy(SjGfjsZsdwkhpj::getKhnr));
        List<SysDictData> GfjsKhnr = sysDictDataMapper.selectDictDataByType("gfjs_sslj");
        for(SysDictData data:GfjsKhnr){
            String dictValue = data.getDictValue();
            List<SjGfjsZsdwkhpj> sjGfjsZsdwkhpjs = stringListMap.get(data.getDictValue());
            //计算分数
            List<Double> doubleList=new ArrayList<>();
            if(sjGfjsZsdwkhpjs==null){
                continue;
            }
//            sjGfjsZsdwkhpjs.forEach(item->{
//                if(StringUtils.isEmpty(item.getKhfz())){
//                    item.setKhfz("0");
//                }
//                doubleList.add(Double.parseDouble(item.getKhfz()));
//            });
//            double kf = doubleList.stream().mapToDouble(Double::doubleValue).sum();
//            if("党建引领".equals(dictValue)){
//                //扣分
//                sjGfjsZsdwkhpjZb.setDjyjkfs(new BigDecimal(kf));
//                //扣分比列
//                BigDecimal df = sjGfjsZsdwkhpjZb.getDjyjzfs().add(new BigDecimal(kf));
//                BigDecimal kfbl =df.divide(sjGfjsZsdwkhpjZb.getDjyjzfs(),4,BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP);
//                sjGfjsZsdwkhpjZb.setDjyjkfbl(new BigDecimal(100).subtract(kfbl));
//                //得分
//                sjGfjsZsdwkhpjZb.setDjyjdf(df);
//
//
//            } else if ("素质提升".equals(dictValue)) {
////扣分
//                sjGfjsZsdwkhpjZb.setSztskfs(new BigDecimal(kf));
//                //扣分比列
//                BigDecimal df = sjGfjsZsdwkhpjZb.getSztszfs().add(new BigDecimal(kf));
//                BigDecimal kfbl =df.divide(sjGfjsZsdwkhpjZb.getSztszfs(),4,BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP);
//                sjGfjsZsdwkhpjZb.setSztsfbl(new BigDecimal(100).subtract(kfbl));
//                //得分
//                sjGfjsZsdwkhpjZb.setSztsdf(df);
//            } else if ("管理精益".equals(dictValue)) {
//                sjGfjsZsdwkhpjZb.setGlgfkfs(new BigDecimal(kf));
//                //扣分比列
//                BigDecimal df = sjGfjsZsdwkhpjZb.getGlgfzfs().add(new BigDecimal(kf));
//                BigDecimal kfbl =df.divide(sjGfjsZsdwkhpjZb.getGlgfzfs(),4,BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP);
//                sjGfjsZsdwkhpjZb.setGlgfbl(new BigDecimal(100).subtract(kfbl));
//                //得分
//                sjGfjsZsdwkhpjZb.setGlgfdf(df);
//            } else if ("业务创效".equals(dictValue)) {
//                sjGfjsZsdwkhpjZb.setYwcxkfs(new BigDecimal(kf));
//                //扣分比列
//                BigDecimal df = sjGfjsZsdwkhpjZb.getYwcxzfs().add(new BigDecimal(kf));
//                BigDecimal kfbl =df.divide(sjGfjsZsdwkhpjZb.getYwcxzfs(),4,BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP);
//                sjGfjsZsdwkhpjZb.setYwcxbl(new BigDecimal(100).subtract(kfbl));
//                //得分
//                sjGfjsZsdwkhpjZb.setYwcxdf(df);
//            }
//
//        }
//
//        BigDecimal sum = sjGfjsZsdwkhpjZb.getDjyjzfs().add(sjGfjsZsdwkhpjZb.getSztszfs()).add(sjGfjsZsdwkhpjZb.getGlgfzfs()).add(sjGfjsZsdwkhpjZb.getYwcxzfs());
//        //总得分
//        BigDecimal sunfs = sjGfjsZsdwkhpjZb.getDjyjdf().add(sjGfjsZsdwkhpjZb.getSztsdf()).add(sjGfjsZsdwkhpjZb.getGlgfdf()).add(sjGfjsZsdwkhpjZb.getYwcxdf());
//        sjGfjsZsdwkhpjZb.setZdf(sunfs);
//        //总扣分
//        sjGfjsZsdwkhpjZb.setZkf(sum.subtract(sunfs));
//        //总扣分比例
//        BigDecimal bigDecimal = sunfs.divide(sum,4,BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP);
//        sjGfjsZsdwkhpjZb.setZkfbl(new BigDecimal(100).subtract(bigDecimal));
//        //综合得分
//        String deptDfl = dept.getDeptDfl();
//        if(StringUtils.isNotEmpty(deptDfl)){
//           if ("B类".equals(deptDfl)) {
//              sjGfjsZsdwkhpjZb.setZhdf( sunfs.multiply(new BigDecimal(0.9)).setScale(2, BigDecimal.ROUND_HALF_UP));
//            }else if ("C类".equals(deptDfl)) {
//               sjGfjsZsdwkhpjZb.setZhdf( sunfs.multiply(new BigDecimal(0.85)).setScale(2, BigDecimal.ROUND_HALF_UP));
//            }else {
//               sjGfjsZsdwkhpjZb.setZhdf(sunfs);
//           }
        }
        //更新主表
        sjGfjsZsdwkhpjZbMapper.updateSjGfjsZsdwkhpjZb(sjGfjsZsdwkhpjZb);
        return sjGfjsZsdwkhpjMapper.pledit(list);
    }

    public static void main(String[] args) {
        System.out.println(Double.parseDouble("-5"));
        System.out.println(Double.parseDouble("+5"));
    }


}
