package com.qianhe.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;

/**
 * 三基帮扶组维护对象 sj_bfzwh
 *
 * @author qianhe
 * @date 2024-08-31
 */
@Data
public class SjGfjsBfzwh extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 帮扶组名称 */
    @Excel(name = "帮扶组名称")
    private String bfzmc;

    /** 联系人 */
    @Excel(name = "联系人")
    private Long lxr;

    private String lxrname;

    /** 年度 */
    @Excel(name = "年度")
    private String nd;

    /** 录入人 */
    @Excel(name = "录入人")
    private String lrr;

    /** 录入时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "录入时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date lrsj;

    /** 修改人 */
    @Excel(name = "修改人")
    private String xgr;

    /** 修改时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "修改时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date xgsj;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 单位组 */
    private Long[] deptIds;

    private String deptNames;

}
