package com.qianhe.controller;

import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.page.TableDataInfo;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.domain.SjGfjsKhwt;
import com.qianhe.domain.SjGfjsKhwtCb;
import com.qianhe.service.ISjGfjsKhwtService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 规范建设-考核问题 原否决项标准Controller
 *
 * @author qianhe
 * @date 2024-07-22
 */
@RestController
@RequestMapping("/system/sjGfjsKhwt")
public class SjGfjsKhwtController extends BaseController
{
    @Autowired
    private ISjGfjsKhwtService sjGfjsKhwtService;

    /**
     * 查询规范建设-考核问题 原否决项标准列表
     */
//    @PreAuthorize("@ss.hasPermi('system:sjGfjsKhwt:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjGfjsKhwt sjGfjsKhwt)
    {
        startPage();
        List<SjGfjsKhwt> list = sjGfjsKhwtService.selectSjGfjsKhwtList(sjGfjsKhwt);
        return getDataTable(list);
    }
    /**
     * 查询规范建设-考核问题 原否决项标准列表
     */
//    @PreAuthorize("@ss.hasPermi('system:sjGfjsKhwt:cxlist')")
    @GetMapping("/cxlist")
    public TableDataInfo cxlist(SjGfjsKhwt sjGfjsKhwt)
    {
//        startPage();
        List<SjGfjsKhwt> list = sjGfjsKhwtService.selectSjGfjsKhwtCxList(sjGfjsKhwt);
        return getDataTable(list);
    }

    /**
     * 导出规范建设-考核问题 原否决项标准列表
     */
//    @PreAuthorize("@ss.hasPermi('system:sjGfjsKhwt:export')")
    @Log(title = "规范建设-考核问题 原否决项标准", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjGfjsKhwt sjGfjsKhwt)
    {
        List<SjGfjsKhwt> list = sjGfjsKhwtService.selectSjGfjsKhwtList(sjGfjsKhwt);
        ExcelUtil<SjGfjsKhwt> util = new ExcelUtil<SjGfjsKhwt>(SjGfjsKhwt.class);
        util.exportExcel(response, list, "规范建设-考核问题 原否决项标准数据");
    }

    /**
     * 获取规范建设-考核问题 原否决项标准详细信息
     */
//    @PreAuthorize("@ss.hasPermi('system:sjGfjsKhwt:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjGfjsKhwtService.selectSjGfjsKhwtById(id));
    }

    /**
     * 新增规范建设-考核问题 原否决项标准
     */
//    @PreAuthorize("@ss.hasPermi('system:sjGfjsKhwt:add')")
    @Log(title = "规范建设-考核问题 原否决项标准", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjGfjsKhwt sjGfjsKhwt)
    {
        return toAjax(sjGfjsKhwtService.insertSjGfjsKhwt(sjGfjsKhwt));
    }

    /**
     * 修改规范建设-考核问题 原否决项标准
     */
//    @PreAuthorize("@ss.hasPermi('system:sjGfjsKhwt:edit')")
    @Log(title = "规范建设-考核问题 原否决项标准", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjGfjsKhwt sjGfjsKhwt)
    {
        return toAjax(sjGfjsKhwtService.updateSjGfjsKhwt(sjGfjsKhwt));
    }

    /**
     * 删除规范建设-考核问题 原否决项标准
     */
//    @PreAuthorize("@ss.hasPermi('system:sjGfjsKhwt:remove')")
    @Log(title = "规范建设-考核问题 原否决项标准", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjGfjsKhwtService.deleteSjGfjsKhwtByIds(ids));
    }



    /**
     * 查询分类名称集合
     * @param cb
     * @return
     */
    @GetMapping("/getFlmcList")
    public AjaxResult getFlmcList(SjGfjsKhwtCb cb){
        String nd = cb.getNd();
        cb.setNd(nd.substring(0,4));
        List<String> flmcList = sjGfjsKhwtService.getFlmcList(cb);
        return success(flmcList);
    }


    /**
     * 查询分类名称集合
     * @param cb
     * @return
     */
    @GetMapping("/getPjbzList")
    public AjaxResult getPjbzList(SjGfjsKhwtCb cb){
        String nd = cb.getNd();
        cb.setNd(nd.substring(0,4));
        List<SjGfjsKhwtCb> pjbzList = sjGfjsKhwtService.getPjbzList(cb);
        return success(pjbzList);
    }
}
