package com.qianhe.controller;

import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.domain.entity.SysDept;
import com.qianhe.common.core.domain.entity.SysRole;
import com.qianhe.common.core.page.TableDataInfo;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.domain.SjGfjsBfzbfdx;
import com.qianhe.domain.SjGfjsBfzwh;
import com.qianhe.service.ISjGfjsBfzwhService;
import com.qianhe.system.service.ISysDeptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 三基帮扶组维护Controller
 *
 * @author qianhe
 * @date 2024-08-31
 */
@RestController
@RequestMapping("/system/sjGfjsBfzwh")
public class SjGfjsBfzwhController extends BaseController
{
    @Autowired
    private ISjGfjsBfzwhService sjGfjsBfzwhService;

    /**
     * 查询三基帮扶组维护列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SjGfjsBfzwh sjGfjsBfzwh)
    {
        sjGfjsBfzwh.setLxr(SecurityUtils.getUserId());
        // 拿到角色如果是管理员 不限制。不是管理员只能看到自己的帮扶组
        List<SysRole> rolelist = SecurityUtils.getLoginUser().getUser().getRoles();
        if(StringUtils.isNotEmpty(rolelist)){
            for (SysRole role :rolelist){
                Long roleid = role.getRoleId();
                if(roleid==1||roleid==100){
                    sjGfjsBfzwh.setLxr(null);
                }
            }
        }
        startPage();
        List<SjGfjsBfzwh> list = sjGfjsBfzwhService.selectSjGfjsBfzwhList(sjGfjsBfzwh);
        return getDataTable(list);
    }

    /**
     * 查询三基帮扶组维护下拉框
     */
    @GetMapping("/xlklist")
    public TableDataInfo xlklist(SjGfjsBfzwh sjGfjsBfzwh)
    {
        // 获取当前登陆人
        sjGfjsBfzwh.setLxr(SecurityUtils.getUserId());
        // 拿到角色如果是管理员 不限制。不是管理员只能看到自己的帮扶组
        List<SysRole> rolelist = SecurityUtils.getLoginUser().getUser().getRoles();
        if(StringUtils.isNotEmpty(rolelist)){
            for (SysRole role :rolelist){
                Long roleid = role.getRoleId();
                if(roleid==1||roleid==100){
                    sjGfjsBfzwh.setLxr(null);
                }
            }
        }
        List<SjGfjsBfzwh> list = sjGfjsBfzwhService.selectSjGfjsBfzwhList(sjGfjsBfzwh);
        return getDataTable(list);
    }

    /**
     * 导出三基帮扶组维护列表
     */
    @Log(title = "三基帮扶组维护", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjGfjsBfzwh sjGfjsBfzwh)
    {
        // 获取当前登陆人
       sjGfjsBfzwh.setLxr(SecurityUtils.getUserId());

        List<SjGfjsBfzwh> list = sjGfjsBfzwhService.selectSjGfjsBfzwhList(sjGfjsBfzwh);
        ExcelUtil<SjGfjsBfzwh> util = new ExcelUtil<SjGfjsBfzwh>(SjGfjsBfzwh.class);
        util.exportExcel(response, list, "三基帮扶组维护数据");
    }

    /**
     * 获取三基帮扶组维护详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjGfjsBfzwhService.selectSjGfjsBfzwhById(id));
    }

    /**
     * 新增三基帮扶组维护
     */
    @Log(title = "三基帮扶组维护", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjGfjsBfzwh sjGfjsBfzwh)
    {
        return toAjax(sjGfjsBfzwhService.insertSjGfjsBfzwh(sjGfjsBfzwh));
    }

    /**
     * 修改三基帮扶组维护
     */
    @Log(title = "三基帮扶组维护", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjGfjsBfzwh sjGfjsBfzwh)
    {
        return toAjax(sjGfjsBfzwhService.updateSjGfjsBfzwh(sjGfjsBfzwh));
    }

    /**
     * 删除三基帮扶组维护
     */
    @Log(title = "三基帮扶组维护", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjGfjsBfzwhService.deleteSjGfjsBfzwhByIds(ids));
    }

    @Autowired
    private ISysDeptService deptService;
    /**
     * 加载对应帮扶组单位列表树
     */
    @GetMapping(value = "/bfzBfdxTreeselect/{id}")
    public AjaxResult roleMenuTreeselect(@PathVariable("id") Long id)
    {
        List<SysDept> depts = deptService.selectDeptList_sy(new SysDept());
        AjaxResult ajax = AjaxResult.success();
        ajax.put("checkedKeys", sjGfjsBfzwhService.selectBfdxListByBfz(id));
        ajax.put("menus", sjGfjsBfzwhService.buildBfdwTreeSelect(depts));
        return ajax;
    }

    /**
     * 获取菜单下拉树列表
     */
    @GetMapping("/deptTreeselect")
    public AjaxResult treeselect(SysDept dept)
    {
        List<SysDept> depts = deptService.selectDeptList_sy(new SysDept());
        return success(sjGfjsBfzwhService.buildBfdwTreeSelect(depts));
    }

    /**
     * 查询帮扶对象下拉框
     */
    @GetMapping("/bfdxlist")
    public TableDataInfo selectBfdxlist(SjGfjsBfzbfdx sjGfjsBfzbfdx)
    {
        List<SjGfjsBfzbfdx> list = sjGfjsBfzwhService.selectBfdxlist(sjGfjsBfzbfdx);
        return getDataTable(list);
    }
}
