package com.qianhe.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.qianhe.domain.BzscYsjglggzscZb;
import com.qianhe.service.IBzscYsjglggzscZbService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;

import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 标准手册-油水井管理岗工作手册-主Controller
 *
 * @author qianhe
 * @date 2024-10-09
 */
@RestController
@RequestMapping("/system/zb")
public class BzscYsjglggzscZbController extends BaseController
{
    @Autowired
    private IBzscYsjglggzscZbService bzscYsjglggzscZbService;

    /**
     * 查询标准手册-油水井管理岗工作手册-主列表
     */
    @PreAuthorize("@ss.hasPermi('system:zb:list')")
    @GetMapping("/list")
    public TableDataInfo list(BzscYsjglggzscZb bzscYsjglggzscZb)
    {
        startPage();
        List<BzscYsjglggzscZb> list = bzscYsjglggzscZbService.selectBzscYsjglggzscZbList(bzscYsjglggzscZb);
        return getDataTable(list);
    }

    /**
     * 导出标准手册-油水井管理岗工作手册-主列表
     */
    @PreAuthorize("@ss.hasPermi('system:zb:export')")
    @Log(title = "标准手册-油水井管理岗工作手册-主", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, BzscYsjglggzscZb bzscYsjglggzscZb)
    {
        List<BzscYsjglggzscZb> list = bzscYsjglggzscZbService.selectBzscYsjglggzscZbList(bzscYsjglggzscZb);
        ExcelUtil<BzscYsjglggzscZb> util = new ExcelUtil<BzscYsjglggzscZb>(BzscYsjglggzscZb.class);
        util.exportExcel(response, list, "标准手册-油水井管理岗工作手册-主数据");
    }

    /**
     * 获取标准手册-油水井管理岗工作手册-主详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:zb:query')")
    @GetMapping(value = "/{ID}")
    public AjaxResult getInfo(@PathVariable("ID") Long ID)
    {
        return success(bzscYsjglggzscZbService.selectBzscYsjglggzscZbByID(ID));
    }

    /**
     * 新增标准手册-油水井管理岗工作手册-主
     */
    @PreAuthorize("@ss.hasPermi('system:zb:add')")
    @Log(title = "标准手册-油水井管理岗工作手册-主", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BzscYsjglggzscZb bzscYsjglggzscZb)
    {
        return toAjax(bzscYsjglggzscZbService.insertBzscYsjglggzscZb(bzscYsjglggzscZb));
    }

    /**
     * 修改标准手册-油水井管理岗工作手册-主
     */
    @PreAuthorize("@ss.hasPermi('system:zb:edit')")
    @Log(title = "标准手册-油水井管理岗工作手册-主", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BzscYsjglggzscZb bzscYsjglggzscZb)
    {
        return toAjax(bzscYsjglggzscZbService.updateBzscYsjglggzscZb(bzscYsjglggzscZb));
    }

    /**
     * 删除标准手册-油水井管理岗工作手册-主
     */
    @PreAuthorize("@ss.hasPermi('system:zb:remove')")
    @Log(title = "标准手册-油水井管理岗工作手册-主", businessType = BusinessType.DELETE)
	@DeleteMapping("/{IDs}")
    public AjaxResult remove(@PathVariable Long[] IDs)
    {
        return toAjax(bzscYsjglggzscZbService.deleteBzscYsjglggzscZbByIDs(IDs));
    }
}
