package com.qianhe.bzsc.service.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.qianhe.bzsc.mapper.BzscCyglqglscMbcbMapper;
import com.qianhe.bzsc.domain.BzscCyglqglscMbcb;
import com.qianhe.bzsc.service.IBzscCyglqglscMbcbService;

/**
 * 标准手册-采油管理区管理手册-模板从Service业务层处理
 *
 * @author qianhe
 * @date 2024-11-11
 */
@Service
public class BzscCyglqglscMbcbServiceImpl implements IBzscCyglqglscMbcbService
{
    @Autowired
    private BzscCyglqglscMbcbMapper bzscCyglqglscMbcbMapper;

    /**
     * 查询标准手册-采油管理区管理手册-模板从
     *
     * @param ID 标准手册-采油管理区管理手册-模板从主键
     * @return 标准手册-采油管理区管理手册-模板从
     */
    @Override
    public BzscCyglqglscMbcb selectBzscCyglqglscMbcbByID(Long ID)
    {
        return bzscCyglqglscMbcbMapper.selectBzscCyglqglscMbcbByID(ID);
    }

    /**
     * 查询标准手册-采油管理区管理手册-模板从列表
     *
     * @param bzscCyglqglscMbcb 标准手册-采油管理区管理手册-模板从
     * @return 标准手册-采油管理区管理手册-模板从
     */
    @Override
    public List<BzscCyglqglscMbcb> selectBzscCyglqglscMbcbList(BzscCyglqglscMbcb bzscCyglqglscMbcb)
    {
        return bzscCyglqglscMbcbMapper.selectBzscCyglqglscMbcbList(bzscCyglqglscMbcb);
    }

    /**
     * 新增标准手册-采油管理区管理手册-模板从
     *
     * @param bzscCyglqglscMbcb 标准手册-采油管理区管理手册-模板从
     * @return 结果
     */
    @Override
    public int insertBzscCyglqglscMbcb(BzscCyglqglscMbcb bzscCyglqglscMbcb)
    {
        bzscCyglqglscMbcb.setCreateTime(DateUtils.getNowDate());
        return bzscCyglqglscMbcbMapper.insertBzscCyglqglscMbcb(bzscCyglqglscMbcb);
    }

    /**
     * 修改标准手册-采油管理区管理手册-模板从
     *
     * @param bzscCyglqglscMbcb 标准手册-采油管理区管理手册-模板从
     * @return 结果
     */
    @Override
    public int updateBzscCyglqglscMbcb(BzscCyglqglscMbcb bzscCyglqglscMbcb)
    {
        bzscCyglqglscMbcb.setUpdateTime(DateUtils.getNowDate());
        return bzscCyglqglscMbcbMapper.updateBzscCyglqglscMbcb(bzscCyglqglscMbcb);
    }

    /**
     * 批量删除标准手册-采油管理区管理手册-模板从
     *
     * @param IDs 需要删除的标准手册-采油管理区管理手册-模板从主键
     * @return 结果
     */
    @Override
    public int deleteBzscCyglqglscMbcbByIDs(Long[] IDs)
    {
        return bzscCyglqglscMbcbMapper.deleteBzscCyglqglscMbcbByIDs(IDs);
    }

    /**
     * 删除标准手册-采油管理区管理手册-模板从信息
     *
     * @param ID 标准手册-采油管理区管理手册-模板从主键
     * @return 结果
     */
    @Override
    public int deleteBzscCyglqglscMbcbByID(Long ID)
    {
        return bzscCyglqglscMbcbMapper.deleteBzscCyglqglscMbcbByID(ID);
    }


    @Override
    public List<BzscCyglqglscMbcb> selectBzscCyglqglscMbcbList_ByZbid(Long zbId)
    {
        List<BzscCyglqglscMbcb> cbList = bzscCyglqglscMbcbMapper.selectBzscCyglqglscMbcbList_ByZbid(zbId);
        return buildDeptTree(cbList);
    }

    public List<BzscCyglqglscMbcb> buildDeptTree(List<BzscCyglqglscMbcb> cbList)
    {
        List<BzscCyglqglscMbcb> returnList = new ArrayList<BzscCyglqglscMbcb>();
        List<Long> tempList = cbList.stream().map(BzscCyglqglscMbcb::getID).collect(Collectors.toList());
        for (BzscCyglqglscMbcb cb : cbList)
        {
            // 如果是顶级节点, 遍历该父节点的所有子节点
            if (!tempList.contains(cb.getParentId()))
            {
                recursionFn(cbList, cb);
                returnList.add(cb);
            }
        }
        if (returnList.isEmpty())
        {
            returnList = cbList;
        }
        return returnList;
    }

    /**
     * 递归列表
     */
    private void recursionFn(List<BzscCyglqglscMbcb> list, BzscCyglqglscMbcb t)
    {
        // 得到子节点列表
        List<BzscCyglqglscMbcb> childList = getChildList(list, t);
        t.setChildList(childList);
        for (BzscCyglqglscMbcb tChild : childList)
        {
            if (hasChild(list, tChild))
            {
                recursionFn(list, tChild);
            }
        }
    }

    /**
     * 得到子节点列表
     */
    private List<BzscCyglqglscMbcb> getChildList(List<BzscCyglqglscMbcb> list, BzscCyglqglscMbcb t)
    {
        List<BzscCyglqglscMbcb> tlist = new ArrayList<BzscCyglqglscMbcb>();
        Iterator<BzscCyglqglscMbcb> it = list.iterator();
        while (it.hasNext())
        {
            BzscCyglqglscMbcb n = (BzscCyglqglscMbcb) it.next();
            if (StringUtils.isNotNull(n.getParentId()) && n.getParentId().longValue() == t.getID().longValue())
            {
                tlist.add(n);
            }
        }
        return tlist;
    }

    /**
     * 判断是否有子节点
     */
    private boolean hasChild(List<BzscCyglqglscMbcb> list, BzscCyglqglscMbcb t)
    {
        return getChildList(list, t).size() > 0;
    }

    @Override
    public boolean hasChildByID(Long ID)
    {
        int result = bzscCyglqglscMbcbMapper.hasChildByID(ID);
        return result > 0;
    }
}
