package com.qianhe.bzsc.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.qianhe.bzsc.domain.BzscCyglqglscMbcb;
import com.qianhe.bzsc.service.IBzscCyglqglscMbcbService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.bzsc.domain.BzscCyglqglscMbzb;
import com.qianhe.bzsc.service.IBzscCyglqglscMbzbService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 标准手册-采油管理区管理手册-模板主Controller
 *
 * @author qianhe
 * @date 2024-11-11
 */
@RestController
@RequestMapping("/bzsc/bzscCyglqglscMbzb")
public class BzscCyglqglscMbzbController extends BaseController
{
    @Autowired
    private IBzscCyglqglscMbzbService bzscCyglqglscMbzbService;

    /**
     * 查询标准手册-采油管理区管理手册-模板主列表
     */
    @GetMapping("/list")
    public TableDataInfo list(BzscCyglqglscMbzb bzscCyglqglscMbzb)
    {
        startPage();
        List<BzscCyglqglscMbzb> list = bzscCyglqglscMbzbService.selectBzscCyglqglscMbzbList(bzscCyglqglscMbzb);
        return getDataTable(list);
    }

    /**
     * 导出标准手册-采油管理区管理手册-模板主列表
     */
    @Log(title = "标准手册-采油管理区管理手册-模板主", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, BzscCyglqglscMbzb bzscCyglqglscMbzb)
    {
        List<BzscCyglqglscMbzb> list = bzscCyglqglscMbzbService.selectBzscCyglqglscMbzbList(bzscCyglqglscMbzb);
        ExcelUtil<BzscCyglqglscMbzb> util = new ExcelUtil<BzscCyglqglscMbzb>(BzscCyglqglscMbzb.class);
        util.exportExcel(response, list, "标准手册-采油管理区管理手册-模板主数据");
    }

    /**
     * 获取标准手册-采油管理区管理手册-模板主详细信息
     */
    @GetMapping(value = "/{ID}")
    public AjaxResult getInfo(@PathVariable("ID") Long ID)
    {
        return success(bzscCyglqglscMbzbService.selectBzscCyglqglscMbzbByID(ID));
    }

    /**
     * 新增标准手册-采油管理区管理手册-模板主
     */
    @Log(title = "标准手册-采油管理区管理手册-模板主", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BzscCyglqglscMbzb bzscCyglqglscMbzb)
    {
        return toAjax(bzscCyglqglscMbzbService.insertBzscCyglqglscMbzb(bzscCyglqglscMbzb));
    }

    /**
     * 修改标准手册-采油管理区管理手册-模板主
     */
    @Log(title = "标准手册-采油管理区管理手册-模板主", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BzscCyglqglscMbzb bzscCyglqglscMbzb)
    {
        return toAjax(bzscCyglqglscMbzbService.updateBzscCyglqglscMbzb(bzscCyglqglscMbzb));
    }

    @Autowired
    private IBzscCyglqglscMbcbService bzscCyglqglscMbcbService;
    /**
     * 删除标准手册-采油管理区管理手册-模板主
     */
    @Log(title = "标准手册-采油管理区管理手册-模板主", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ID}")
    public AjaxResult remove(@PathVariable Long ID)
    {
        List<BzscCyglqglscMbcb> list = bzscCyglqglscMbcbService.selectBzscCyglqglscMbcbList_ByZbid(ID);
        if (list.size()>0)
        {
            return warn("存在明细内容，不允许删除");
        }
        return toAjax(bzscCyglqglscMbzbService.deleteBzscCyglqglscMbzbByID(ID));
    }
}
