package com.qianhe.system.domain;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;

/**
 * 单位从对象 sys_dept_cb
 *
 * @author qianhe
 * @date 2024-07-10
 */
public class SysDeptCb extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 单位 */
    @Excel(name = "单位")
    private String deptId;

    /** 年度 */
    @Excel(name = "年度")
    private String nd;

    /** 单位类型（油气开发单位、主要专业化单位、科研、监督、服务协调单位） */
    @Excel(name = "单位类型", readConverterExp = "油=气开发单位、主要专业化单位、科研、监督、服务协调单位")
    private String dwlx;

    /** 交油气量（万吨）/经营收入（万元） */
    @Excel(name = "交油气量", readConverterExp = "万=吨")
    private BigDecimal jyqlhjysr;

    /** 基层人员数量 */
    @Excel(name = "基层人员数量")
    private Long jcrysl;

    /** 基层单位数量 */
    @Excel(name = "基层单位数量")
    private Long jcdwsl;

    /** 一线班站数量 */
    @Excel(name = "一线班站数量")
    private Long yxbzsl;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setDeptId(String deptId)
    {
        this.deptId = deptId;
    }

    public String getDeptId()
    {
        return deptId;
    }
    public void setNd(String nd)
    {
        this.nd = nd;
    }

    public String getNd()
    {
        return nd;
    }
    public void setDwlx(String dwlx)
    {
        this.dwlx = dwlx;
    }

    public String getDwlx()
    {
        return dwlx;
    }
    public void setJyqlhjysr(BigDecimal jyqlhjysr)
    {
        this.jyqlhjysr = jyqlhjysr;
    }

    public BigDecimal getJyqlhjysr()
    {
        return jyqlhjysr;
    }
    public void setJcrysl(Long jcrysl)
    {
        this.jcrysl = jcrysl;
    }

    public Long getJcrysl()
    {
        return jcrysl;
    }
    public void setJcdwsl(Long jcdwsl)
    {
        this.jcdwsl = jcdwsl;
    }

    public Long getJcdwsl()
    {
        return jcdwsl;
    }
    public void setYxbzsl(Long yxbzsl)
    {
        this.yxbzsl = yxbzsl;
    }

    public Long getYxbzsl()
    {
        return yxbzsl;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("deptId", getDeptId())
            .append("nd", getNd())
            .append("dwlx", getDwlx())
            .append("jyqlhjysr", getJyqlhjysr())
            .append("jcrysl", getJcrysl())
            .append("jcdwsl", getJcdwsl())
            .append("yxbzsl", getYxbzsl())
            .toString();
    }
}
