package com.qianhe.service.impl;

import java.util.List;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.domain.JygxYyxtwh;
import com.qianhe.mapper.JygxYyxtwhMapper;
import com.qianhe.service.IJygxYyxtwhService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 经验共享-应用系统维护Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-29
 */
@Service
public class JygxYyxtwhServiceImpl implements IJygxYyxtwhService
{
    @Autowired
    private JygxYyxtwhMapper jygxYyxtwhMapper;

    /**
     * 查询经验共享-应用系统维护
     *
     * @param yyxtid 经验共享-应用系统维护主键
     * @return 经验共享-应用系统维护
     */
    @Override
    public JygxYyxtwh selectJygxYyxtwhByYyxtid(Long yyxtid)
    {
        return jygxYyxtwhMapper.selectJygxYyxtwhByYyxtid(yyxtid);
    }

    /**
     * 查询经验共享-应用系统维护列表
     *
     * @param jygxYyxtwh 经验共享-应用系统维护
     * @return 经验共享-应用系统维护
     */
    @Override
    public List<JygxYyxtwh> selectJygxYyxtwhList(JygxYyxtwh jygxYyxtwh)
    {
        return jygxYyxtwhMapper.selectJygxYyxtwhList(jygxYyxtwh);
    }

    /**
     * 新增经验共享-应用系统维护
     *
     * @param jygxYyxtwh 经验共享-应用系统维护
     * @return 结果
     */
    @Override
    public int insertJygxYyxtwh(JygxYyxtwh jygxYyxtwh)
    {
        jygxYyxtwh.setCreateTime(DateUtils.getNowDate());
        return jygxYyxtwhMapper.insertJygxYyxtwh(jygxYyxtwh);
    }

    /**
     * 修改经验共享-应用系统维护
     *
     * @param jygxYyxtwh 经验共享-应用系统维护
     * @return 结果
     */
    @Override
    public int updateJygxYyxtwh(JygxYyxtwh jygxYyxtwh)
    {
        jygxYyxtwh.setUpdateTime(DateUtils.getNowDate());
        return jygxYyxtwhMapper.updateJygxYyxtwh(jygxYyxtwh);
    }

    /**
     * 批量删除经验共享-应用系统维护
     *
     * @param yyxtids 需要删除的经验共享-应用系统维护主键
     * @return 结果
     */
    @Override
    public int deleteJygxYyxtwhByYyxtids(Long[] yyxtids)
    {
        return jygxYyxtwhMapper.deleteJygxYyxtwhByYyxtids(yyxtids);
    }

    /**
     * 删除经验共享-应用系统维护信息
     *
     * @param yyxtid 经验共享-应用系统维护主键
     * @return 结果
     */
    @Override
    public int deleteJygxYyxtwhByYyxtid(Long yyxtid)
    {
        return jygxYyxtwhMapper.deleteJygxYyxtwhByYyxtid(yyxtid);
    }
}
