package com.qianhe.domain;

import java.math.BigDecimal;
import java.util.List;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;

/**
 * 三基-费用报批主对象 sj_fybp_zb
 *
 * @author qianhe
 * @date 2024-07-11
 */
@Data
public class SjFybpZb extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 费用日期 */
    @Excel(name = "费用日期")
    private String fyrq;

    /** 单位 */
    @Excel(name = "单位")
    private String deptId;

    /** 费用金额 */
    @Excel(name = "费用金额")
    private BigDecimal fyje;

    /** 状态(未提交、待审批、已审批、已驳回) */
    @Excel(name = "状态(未提交、待审批、已审批、已驳回)")
    private String zt;

    /** 提交人 */
    @Excel(name = "提交人")
    private String tjr;

    /** 提交日期 */
    @Excel(name = "提交日期")
    private String tjrq;

    /** 审批日期 */
    @Excel(name = "审批日期")
    private String sprq;

    /** 审批人 */
    @Excel(name = "审批人")
    private String spr;

    /** 已使用金额 */
    @Excel(name = "已使用金额")
    private BigDecimal ysyje;

    /** 审批意见 */
    @Excel(name = "审批意见")
    private String spyj;

    /** 预留1 */
    @Excel(name = "预留1")
    private String yl1;

    /** 预留2 */
    @Excel(name = "预留2")
    private String yl2;

    /** 预留3 */
    @Excel(name = "预留3")
    private String yl3;

    /** 预留4 */
    @Excel(name = "预留4")
    private String yl4;

    /** 预留5 */
    @Excel(name = "预留5")
    private String yl5;

    /** 三基-费用报批信息 */
    private List<SjFybp> sjFybpList;


    private List<WdWdxx> fileList;

    private String deptName;

    private String sprName;

    private String spcx;

    private String tqbz;
    private String jsbz;
    private String jl;

    private Boolean jlflag;

}
