package com.qianhe.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.qianhe.domain.JygxCljwh;
import com.qianhe.service.IJygxCljwhService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;

import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 经验共享-超链接维护Controller
 *
 * @author qianhe
 * @date 2024-07-30
 */
@RestController
@RequestMapping("/system/cljwh")
public class JygxCljwhController extends BaseController
{
    @Autowired
    private IJygxCljwhService jygxCljwhService;

    /**
     * 查询经验共享-超链接维护列表
     */
    @PreAuthorize("@ss.hasPermi('system:cljwh:list')")
    @GetMapping("/list")
    public TableDataInfo list(JygxCljwh jygxCljwh)
    {
        startPage();
        List<JygxCljwh> list = jygxCljwhService.selectJygxCljwhList(jygxCljwh);
        return getDataTable(list);
    }

    /**
     * 导出经验共享-超链接维护列表
     */
    @PreAuthorize("@ss.hasPermi('system:cljwh:export')")
    @Log(title = "经验共享-超链接维护", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, JygxCljwh jygxCljwh)
    {
        List<JygxCljwh> list = jygxCljwhService.selectJygxCljwhList(jygxCljwh);
        ExcelUtil<JygxCljwh> util = new ExcelUtil<JygxCljwh>(JygxCljwh.class);
        util.exportExcel(response, list, "经验共享-超链接维护数据");
    }

    /**
     * 获取经验共享-超链接维护详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:cljwh:query')")
    @GetMapping(value = "/{cljid}")
    public AjaxResult getInfo(@PathVariable("cljid") Long cljid)
    {
        return success(jygxCljwhService.selectJygxCljwhByCljid(cljid));
    }

    /**
     * 新增经验共享-超链接维护
     */
    @PreAuthorize("@ss.hasPermi('system:cljwh:add')")
    @Log(title = "经验共享-超链接维护", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody JygxCljwh jygxCljwh)
    {
        return toAjax(jygxCljwhService.insertJygxCljwh(jygxCljwh));
    }

    /**
     * 修改经验共享-超链接维护
     */
    @PreAuthorize("@ss.hasPermi('system:cljwh:edit')")
    @Log(title = "经验共享-超链接维护", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody JygxCljwh jygxCljwh)
    {
        return toAjax(jygxCljwhService.updateJygxCljwh(jygxCljwh));
    }

    /**
     * 删除经验共享-超链接维护
     */
    @PreAuthorize("@ss.hasPermi('system:cljwh:remove')")
    @Log(title = "经验共享-超链接维护", businessType = BusinessType.DELETE)
	@DeleteMapping("/{cljids}")
    public AjaxResult remove(@PathVariable Long[] cljids)
    {
        return toAjax(jygxCljwhService.deleteJygxCljwhByCljids(cljids));
    }
}
