package com.qianhe.service.impl;

import java.util.List;

import com.qianhe.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.qianhe.mapper.WdLxwhMapper;
import com.qianhe.domain.WdLxwh;
import com.qianhe.service.IWdLxwhService;

/**
 * 文档-类型维护Service业务层处理
 *
 * @author qianhe
 * @date 2024-02-28
 */
@Service
public class WdLxwhServiceImpl implements IWdLxwhService
{
    @Autowired
    private WdLxwhMapper wdLxwhMapper;

    /**
     * 查询文档-类型维护
     *
     * @param id 文档-类型维护主键
     * @return 文档-类型维护
     */
    @Override
    public WdLxwh selectWdLxwhById(Long id)
    {
        return wdLxwhMapper.selectWdLxwhById(id);
    }

    /**
     * 查询文档-类型维护列表
     *
     * @param wdLxwh 文档-类型维护
     * @return 文档-类型维护
     */
    @Override
    public List<WdLxwh> selectWdLxwhList(WdLxwh wdLxwh)
    {
        return wdLxwhMapper.selectWdLxwhList(wdLxwh);
    }

    /**
     * 新增文档-类型维护
     *
     * @param wdLxwh 文档-类型维护
     * @return 结果
     */
    @Override
    public int insertWdLxwh(WdLxwh wdLxwh)
    {
        wdLxwh.setLrr(SecurityUtils.getUsername());
        return wdLxwhMapper.insertWdLxwh(wdLxwh);
    }

    /**
     * 修改文档-类型维护
     *
     * @param wdLxwh 文档-类型维护
     * @return 结果
     */
    @Override
    public int updateWdLxwh(WdLxwh wdLxwh)
    {
        wdLxwh.setXgr(SecurityUtils.getUsername());
        return wdLxwhMapper.updateWdLxwh(wdLxwh);
    }

    /**
     * 批量删除文档-类型维护
     *
     * @param ids 需要删除的文档-类型维护主键
     * @return 结果
     */
    @Override
    public int deleteWdLxwhByIds(Long[] ids)
    {
        return wdLxwhMapper.deleteWdLxwhByIds(ids);
    }

    /**
     * 删除文档-类型维护信息
     *
     * @param id 文档-类型维护主键
     * @return 结果
     */
    @Override
    public int deleteWdLxwhById(Long id)
    {
        return wdLxwhMapper.deleteWdLxwhById(id);
    }
}
