package com.qianhe.service.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.core.domain.TreeSelect;
import com.qianhe.common.core.domain.entity.SysDept;
import com.qianhe.domain.SjBfzbfdx;
import com.qianhe.domain.SjBfzwh;
import com.qianhe.mapper.SjBfzwhMapper;
import com.qianhe.service.ISjBfzwhService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


/**
 * 三基帮扶组维护Service业务层处理
 *
 * @author qianhe
 * @date 2024-08-31
 */
@Service
public class SjBfzwhServiceImpl implements ISjBfzwhService
{
    @Autowired
    private SjBfzwhMapper sjBfzwhMapper;

    /**
     * 查询三基帮扶组维护
     *
     * @param id 三基帮扶组维护主键
     * @return 三基帮扶组维护
     */
    @Override
    public SjBfzwh selectSjBfzwhById(Long id)
    {
        return sjBfzwhMapper.selectSjBfzwhById(id);
    }

    /**
     * 根据联系人查询三基帮扶组
     */
    @Override
    public SjBfzwh selectbfz(String lxr)
    {
        return sjBfzwhMapper.selectbfz(lxr);
    }

    /**
     * 查询三基帮扶组维护列表
     *
     * @param sjBfzwh 三基帮扶组维护
     * @return 三基帮扶组维护
     */
    @Override
    public List<SjBfzwh> selectSjBfzwhList(SjBfzwh sjBfzwh)
    {
        return sjBfzwhMapper.selectSjBfzwhList(sjBfzwh);
    }

    /**
     * 新增三基帮扶组维护
     *
     * @param sjBfzwh 三基帮扶组维护
     * @return 结果
     */
    @Override
    @Transactional
    public int insertSjBfzwh(SjBfzwh sjBfzwh)
    {
        sjBfzwhMapper.insertSjBfzwh(sjBfzwh);
        return insertBfzBfdx(sjBfzwh);
    }

    /**
     * 新增帮扶组帮扶对象信息
     *
     */
    public int insertBfzBfdx(SjBfzwh sjBfzwh)
    {
        int rows = 1;
        // 新增用户与角色管理
        List<SjBfzbfdx> list = new ArrayList<SjBfzbfdx>();
        for (Long deptId : sjBfzwh.getDeptIds())
        {
            SjBfzbfdx rm = new SjBfzbfdx();
            rm.setId(sjBfzwh.getId());
            rm.setDeptId(deptId);
            list.add(rm);
        }
        if (list.size() > 0)
        {
            rows = sjBfzwhMapper.batchBfzBfdx(list);
        }
        return rows;
    }

    /**
     * 修改三基帮扶组维护
     *
     * @param sjBfzwh 三基帮扶组维护
     * @return 结果
     */
    @Override
    @Transactional
    public int updateSjBfzwh(SjBfzwh sjBfzwh)
    {
        sjBfzwhMapper.updateSjBfzwh(sjBfzwh);
        // 删除角色与菜单关联
        sjBfzwhMapper.deleteBfzBfdxById(sjBfzwh.getId());
        return insertBfzBfdx(sjBfzwh);
    }

    /**
     * 批量删除三基帮扶组维护
     *
     * @param ids 需要删除的三基帮扶组维护主键
     * @return 结果
     */
    @Override
    @Transactional
    public int deleteSjBfzwhByIds(Long[] ids)
    {
        sjBfzwhMapper.deleteBfzBfdx(ids);
        return sjBfzwhMapper.deleteSjBfzwhByIds(ids);
    }

    /**
     * 删除三基帮扶组维护信息
     *
     * @param id 三基帮扶组维护主键
     * @return 结果
     */
    @Override
    @Transactional
    public int deleteSjBfzwhById(Long id)
    {
        sjBfzwhMapper.deleteBfzBfdxById(id);
        return sjBfzwhMapper.deleteSjBfzwhById(id);
    }

    @Override
    public List<Long> selectBfdxListByBfz(Long id)
    {
        return sjBfzwhMapper.selectBfdxListByBfz(id);
    }

    /**
     * 构建前端所需要下拉树结构
     *
     * @param depts 菜单列表
     * @return 下拉树结构列表
     */
    @Override
    public List<TreeSelect> buildBfdwTreeSelect(List<SysDept> depts)
    {
        List<SysDept> deptTrees = buildBfdwxTree(depts);
        return deptTrees.stream().map(TreeSelect::new).collect(Collectors.toList());
    }

    /**
     * 构建前端所需要树结构
     *
     * @param depts 单位列表
     * @return 树结构列表
     */
    @Override
    public List<SysDept> buildBfdwxTree(List<SysDept> depts)
    {
        List<SysDept> returnList = new ArrayList<SysDept>();
        List<Long> tempList = depts.stream().map(SysDept::getDeptId).collect(Collectors.toList());
        for (Iterator<SysDept> iterator = depts.iterator(); iterator.hasNext();)
        {
            SysDept menu = (SysDept) iterator.next();
            // 如果是顶级节点, 遍历该父节点的所有子节点
            if (!tempList.contains(menu.getParentId()))
            {
                recursionFn(depts, menu);
                returnList.add(menu);
            }
        }
        if (returnList.isEmpty())
        {
            returnList = depts;
        }
        return returnList;
    }

    /**
     * 递归列表
     *
     * @param list 分类表
     * @param t 子节点
     */
    private void recursionFn(List<SysDept> list, SysDept t)
    {
        // 得到子节点列表
        List<SysDept> childList = getChildList(list, t);
        t.setChildren(childList);
        for (SysDept tChild : childList)
        {
            if (hasChild(list, tChild))
            {
                recursionFn(list, tChild);
            }
        }
    }

    /**
     * 得到子节点列表
     */
    private List<SysDept> getChildList(List<SysDept> list, SysDept t)
    {
        List<SysDept> tlist = new ArrayList<SysDept>();
        Iterator<SysDept> it = list.iterator();
        while (it.hasNext())
        {
            SysDept n = (SysDept) it.next();
            if (n.getParentId().longValue() == t.getDeptId().longValue())
            {
                tlist.add(n);
            }
        }
        return tlist;
    }

    /**
     * 判断是否有子节点
     */
    private boolean hasChild(List<SysDept> list, SysDept t)
    {
        return getChildList(list, t).size() > 0;
    }

}
